%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%
function [plate, well, x, y] = parseFile(F)
[plate, well] = split(F);

if isempty(plate) || isempty(well) 
    disp(['error parsing filename ', F]);
    x = 0;
    y = 0;
    return;
end

[x, y] = parse(well);
if isempty(x) || x<0 || isempty(y) || y<0
    disp(['error parsing filename ', F]);
    plate = '';
    well = '';
    return;
end

%currently accept format [a-z][num] or [A-Z][num]
function [x, y] = parse(well)
y = well(1)-'a'+1;
if y<0
    y = well(1)-'A'+1;
end
well(1)=[];
x = str2num(well);

%split by last space or '_'
function [plate, well] = split(F)

idx = find((F==' ')|(F=='_'), 1, 'last');

if isempty(idx)
    disp('ERROR: No underscore or space found:');
    disp(F);
    plate = '';
    well = '';
else
    plate = F(1:idx-1);
    well = F(idx+1:length(F)-4);
end