%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%
function varargout = SpheroidSizer1_0(varargin)
% SPHEROIDSIZER1_0 MATLAB code for SpheroidSizer1_0.fig
%      SPHEROIDSIZER1_0, by itself, creates a new SPHEROIDSIZER1_0 or raises the existing
%      singleton*.
%
%      H = SPHEROIDSIZER1_0 returns the handle to a new SPHEROIDSIZER1_0 or the handle to
%      the existing singleton*.
%
%      SPHEROIDSIZER1_0('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SPHEROIDSIZER1_0.M with the given input arguments.
%
%      SPHEROIDSIZER1_0('Property','Value',...) creates a new SPHEROIDSIZER1_0 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SpheroidSizer1_0_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SpheroidSizer1_0_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SpheroidSizer1_0

% Last Modified by GUIDE v2.5 31-Jul-2013 17:14:59

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @SpheroidSizer1_0_OpeningFcn, ...
    'gui_OutputFcn',  @SpheroidSizer1_0_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

end

%% Executes just before SpheroidSizer1_0 is made visible.
function SpheroidSizer1_0_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SpheroidSizer1_0 (see VARARGIN)

% Choose default command line output for SpheroidSizer1_0
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes SpheroidSizer1_0 wait for user response (see UIRESUME)
% uiwait(handles.guiFigure);

% new configuration
if ~isfield(handles, 'config')
    loadConfig(hObject, handles);
    handles = guidata(hObject);
    if ~isfield(handles, 'config')
        config = newConfig();
        handles.config = config;
    end
end
setStatus(0, handles);

guidata(hObject, handles);
reportCaller('guidata save on open');

end

%% Outputs from this function are returned to the command line.
function varargout = SpheroidSizer1_0_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
end

%%
function reportCaller(msg)
%report function caller to screen
doreport = 0;
[ST,~] = dbstack;
if doreport
    display([msg, ': ',  ST(2).name]);
end
end

%% set gui status
% do not save guidata inside
function setStatus(status, handles)
%
% DBWJ handles
err = 0;
switch status
    case 0 %init
        set(handles.b_compute, 'Enable', 'on');
        set(handles.b_pause, 'Enable', 'off');
        set(handles.b_manual, 'Enable', 'off');
        set(handles.b_handdrawn, 'Enable', 'off');
    case 1 %compute
        handles.flag.pauseComputation = 0;
        setappdata(handles.b_pause, 'paused', 0);
        set(handles.b_pause, 'String', 'Pause');
        set(handles.b_compute, 'Enable', 'off');
        set(handles.b_pause, 'Enable', 'on');
        set(handles.b_manual, 'Enable', 'off');
        set(handles.b_handdrawn, 'Enable', 'off');
        
    case 1.1 %paused
        handles.flag.pauseComputation = 1;
        setappdata(handles.b_pause, 'paused', 1);
        set(handles.b_pause, 'String', 'Continue');
        set(handles.b_compute, 'Enable', 'on');
        set(handles.b_pause, 'Enable', 'on');
        set(handles.b_manual, 'Enable', 'on');
        set(handles.b_handdrawn, 'Enable', 'on');
        
    case 1.5 %parallel
        handles.flag.pauseComputation = 0;
        setappdata(handles.b_pause, 'paused', 0);
        set(handles.b_compute, 'Enable', 'off');
        set(handles.b_pause, 'Enable', 'off');
        set(handles.b_manual, 'Enable', 'off');
        set(handles.b_handdrawn, 'Enable', 'of');
    case 2 %review
        set(handles.b_compute, 'Enable', 'on');
        set(handles.b_pause, 'Enable', 'on');
        set(handles.b_manual, 'Enable', 'on');
        set(handles.b_handdrawn, 'Enable', 'on');
        
    case 2.1  %manual initiate
        
    case 2.2 %hand draw
        set(handles.b_compute, 'Enable', 'off');
        set(handles.b_pause, 'Enable', 'off');
        set(handles.b_manual, 'Enable', 'off');
        set(handles.b_handdrawn, 'Enable', 'off');
        set(handles.l_currentImage, 'String', 'Please draw outline and click image when finished.');
    otherwise
        set(handles.b_compute, 'Enable', 'off');
end
if err>0 return; end
%handles.status = status;
setappdata(handles.guiFigure, 'status', status);
disp(['status changed to: ', num2str(status)]);
pause(.1);
end

%%
function returnStatus = doCompute(handles)
%handles.result is of dimension ncellsx13
%handles.compResult is of dimension ncellsx13

ressize = 13;
returnStatus = 0;

%phase I, prep compute

%new computation prep
%if handles.status==1
if getappdata(handles.guiFigure, 'status')==1
    try
        if isfield(handles, 'filelist')
            delete(handles.filelist);
        end
        %file list
        handles.filelist = FileList();
        addlistener(handles.filelist, 'progress', @(src, evntdata)set(handles.ta_progress, 'String', src.getEventMessage()));
        handles.filelist.readFolder(handles.config);
        if isempty(handles.config.startfolder)
            error('no start folder seleted');
        end
        if handles.filelist.size ==0
            error('no new files read');
        end
        
        %validate files
        failedFileCheck = validateFiles(handles.filelist);
        if ~isempty(failedFileCheck)
            
            % Construct a questdlg with three options
            choice = questdlg('Error exists in filename', ...
                'Please give input', ...
                'Skip error and continue','Exit and show list of errors', 'Exit and show list of errors');
            % Handle response
            switch choice
                case 'Exit and show list of errors'
                    msgbox(failedFileCheck, 'Files failed name check', 'modal')
                    error('Files failed name check', failedFileCheck);
                case 'Skip error and continue'
                    %do nothing and continue
            end
        end
        
        %init handles.compResult and handles.result
        set(handles.tb_image, 'Data', []);
        pause(.1);
        handles.compResult = cell(handles.filelist.size, ressize);
        if isfield(handles, 'result') handles = rmfield(handles, 'result'); end
        handles.result(handles.filelist.size) = struct('folder', '', 'fn', '', 'goodResult', '', 'V', 0, 'PArea', 0, 'PMajorAxis', 0, 'PMinorAxis', 0, 'RArea', 0, 'RMajorAxis', 0, 'RMinorAxis', 0, 'adjfile', '', 'qa', '', 'Eccentricity', 0, 'complete', 0);
        
        
        guidata(handles.b_compute, handles);
        reportCaller('guidata');
    catch err
        setStatus(returnStatus, handles);
        disp(err.message);
        return;
    end
end

tic
if handles.config.parallel == 1  %parallel processing use the parallel loop
    try
        setStatus(1.5, handles);
        
        parallelLoop(handles);
        handles = guidata(handles.guiFigure);
        %for i = 1:handles.filelist.size
        %    handles.compResult(i, :) = cr(i).r;
        %end
        %handles.result = result;
        %guidata(handles.guiFigure, handles);
        %reportCaller('guidata');
        
    catch err
        returnStatus = 1;
        setStatus(returnStatus, handles);
        disp(err.message);
        return;
    end
    
    returnStauts = 2;
    setStatus(returnStauts, handles);
else
    try
        setStatus(1, handles);
        
        %while getappdata(handles.b_pause, 'paused')==0 && idx<handles.filelist.size
        clear cr rr
        %cr(handles.filelist.size).r{ressize} = 1; %local comp result
        FL = handles.filelist;
        config = handles.config;
        result = handles.result;
        tic
        %the computing loop, exit if paused
        
        for idx=1:FL.size
            if getappdata(handles.b_pause, 'paused')==1  %paused, break
                break;
            end
            
            if handles.compResult{idx, ressize}==1 %skip already finished result
                disp(['skipping finished: ',handles.compResult{idx, 2}]);
                continue;
            end
            
            file = FL.computing(idx);
            set(handles.ta_progress, 'String', ['computing ' file.directory, filesep, file.file]);
            pause(.1);
            
            [r, orig, I3] = activeContourCompute([file.directory, filesep, file.file], config);
            result(idx) = r;
            
            handles.compResult(idx,:)= {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity,r.goodResult};
            
            %alert! TODO
            %if result(idx).goodResult==0 || result(idx).Eccentricity>2;
            %    addAlert(idx);
            %end
            
            if handles.config.display
                displayResult(idx, handles, orig, I3);
            end
            
            handles.currentResult = idx;
            
            pause(.1);
            set(handles.tb_image, 'Data', handles.compResult(:, [1,2,3,8,9,13]));
            
            guidata(handles.guiFigure, handles);
            reportCaller('guidata');
            handles = guidata(handles.guiFigure);
        end
    catch err
        returnStatus = 1;
        setStatus(returnStatus, handles);
        disp(getReport(err))
    end
    
    if getappdata(handles.b_pause, 'paused')==0
        returnStatus = 2; %done
    else
        returnStatus = 1.1; %paused
    end
    setStatus(returnStatus, handles);
    
end

guidata(handles.guiFigure, handles);
reportCaller('guidata');

toc


%handles = setStatus(returnStatus, handles);
%guidata(handles.guiFigure, handles);
%reportCaller('guidata, after return status being set');
%handles.status
end

%%
%function [cr, result] = parallelLoop(handles)
function parallelLoop(handles)
ressize = 13;

%create variables to be used in loop
%cr(handles.filelist.size).r = cell(1, ressize);
FL = handles.filelist;
config = handles.config;
result = handles.result;

h = waitbar(0, 'please wait for the parallel work');
try
    eval(['matlabpool ', num2str(handles.config.nworker)]);
catch err
    try
        matlabpool close
        eval(['matlabpool ', num2str(handles.config.nworker)]);
    catch err2
        rethrow(err2);
    end
end

try
    parfor idx=1:FL.size
        
        file = FL.computing(idx);
        
        r = activeContourCompute([file.directory, filesep, file.file], config);
        result(idx) = r;
        
        %cr(idx).r = {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity, 1};
        
        %alert! need to move to end
        if result(idx).goodResult==0 || result(idx).Eccentricity>2;
            addAlert(idx);
        end
    end
catch err
    disp(err)
end
matlabpool close
close(h);

set(handles.ta_progress, 'String', ['Finished computing.']);
setStatus(2, handles);
handles.compResult = cell(handles.filelist.size, ressize);
for idx = 1:FL.size
    r = result(idx);
    handles.compResult(idx,:)= {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity,r.goodResult};
end
set(handles.tb_image, 'Data', handles.compResult(:, [1,2,3,8,9,13]));
guidata(handles.guiFigure, handles);
pause(.2);
reportCaller('guidata');
end

%%
function ret = displayResult(idx,  handles, orig, I3 )
ret = 0;
%display image result of the idx'th cell on the right
if ~isfield(handles, 'compResult')
    return;
end
entry = handles.compResult(idx, :);
if isempty(entry{1})
    return;
end
    
if ~exist('I3', 'var')
    %load
    %TODO check whether computed at all
    if exist(entry{10}, 'file')  %whether adj exists
        orig = imread(entry{10});
    else
        orig = imread([entry{1}, filesep, entry{2}]);
    end
    
    I3 = imread(entry{11});
end

displayMode(handles, 0);

axes(handles.ax_orig);
cla
imshow(uint8(orig));
axes(handles.ax_res);
cla
imshow(I3);
if ~handles.compResult{idx, 13}
    text(5,5, 'Invalid', 'Color', [1,0,0]);
end
set(handles.l_currentImage, 'String', handles.compResult{idx, 2});

ret = 1;
%set(handles.ax_orig, 'Visible', 'on');
%set(handles.ax_res, 'Visible', 'on');
end

%% fresh config
% no saving
function config = newConfig()
disp('new configuration');
clear config
config.startfolder = '.';
config.outfile = 'out.txt';
config.formatout = 'format.txt';
config.subfolder = 1;
config.resolution = 1.294;
config.size = 's';
config.shrink = 10;
config.includetype = {'.jpg','.tif','bmp'};
config.qc = '_qc.jpg';
config.adj = '_8.jpg';
config.excludetype = {config.qc, config.adj, '_crude.jpg'};
config.specialcolor = 'None';
config.parallel = 0;
config.plate = 1;
config.nworker = 12;
end
%% read config from config.mat
% no saving occurred!!
function config = readConfig()
if exist('config.mat', 'file')
    load config.mat;
else
    disp('no config.mat file present');
    config = [];
end
end

%% gather configuration from gui
% no saving
function config = gatherConfig(handles)
config = handles.config;
config.startfolder = get(handles.tf_folder, 'String');
config.display = get(handles.rb_display, 'Value');
config.subfolder = get(handles.rb_subfolder, 'Value');
config.resolution = str2double(get(handles.tf_resolution, 'String'));
config.size = get(handles.cb_size, 'Value');
end

%% update gui to reflect config
function gui_config(config, handles)
set(handles.tf_folder, 'String', config.startfolder);
%set(handles.tf_outfile, 'String', config.outfile);
set(handles.rb_subfolder, 'Value', config.subfolder);
set(handles.rb_display, 'Value', config.display);
set(handles.tf_resolution, 'String', num2str(config.resolution));
%TODO size
end

%%
function addAlert(out)
disp(out);
end

%%
function outputResults(result, folder, out)
% handles.compResult(idx,:)= {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity,r.complete==1
fid = fopen([folder, filesep, out], 'w');
disp([folder, filesep, out]);
if fid==0
    msgbox(['can not open outputfile ',folder, filesep, out, '. Please check Advanced Configuration.']);
    return;
end

fprintf(fid, ...
    '%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n', ...
    'folder', ...
    'file', ...
    'volume', ...
    'pixelArea', ...
    'pixelMajorAxis', ...
    'pixelMinorAxis', ...
    'area', ...
    'majorAxis', ...
    'minorAxis', ...
    'adjustFile', ...
    'qaFile', ...
    'eccentricity', ...
    'valid');

for i = 1:size(result, 1)
    if result{i,13}
        fprintf(fid, ...
            '%s\t%s\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%s\t%s\t%f\t%d\n', ...
            result{i,1}, ...
            result{i,2}, ...
            result{i,3}, ...
            result{i,4}, ...
            result{i,5}, ...
            result{i,6},  ...
            result{i,7},  ...
            result{i,8},  ...
            result{i,9},  ...
            result{i,10},  ...
            result{i,11},  ...
            result{i,12},  ...
            result{i,13});
    else
        fprintf(fid, ...
        '%s\t%s\t\t\t\t\t\t\t\t\t\t\t%d\n', ...
        result{i,1}, ...
        result{i,2}, ...
        result{i,13});
    end
end

fclose(fid);
end

%%
function tf_folder_Callback(hObject, eventdata, handles)
% hObject    handle to tf_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_folder as text
%        str2double(get(hObject,'String')) returns contents of tf_folder as a double

end

%% Executes during object creation, after setting all properties.
function tf_folder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

end

%% Executes on button press in b_folder.
function b_folder_Callback(hObject, ~, handles)
% hObject    handle to b_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isfield(handles, 'config')
    disp('error: config did not exist');
    return;
end

if ~isfield(handles.config, 'startfolder') || ~isstr(handles.config.startfolder)
    handles.config.startfolder = '.';
end

ret = uigetdir(handles.config.startfolder, 'Select Starting Folder')
if ret==0
    return;
end
handles.config.startfolder = ret;
set(handles.tf_folder, 'String', handles.config.startfolder);
guidata(hObject, handles);
reportCaller('guidata');
end
%% Executes on button press in rb_subfolder.
function rb_subfolder_Callback(hObject, eventdata, handles)
% hObject    handle to rb_subfolder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rb_subfolder
% TODO
end

%%
function tf_resolution_Callback(hObject, eventdata, handles)
% hObject    handle to tf_resolution (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_resolution as text
%        str2double(get(hObject,'String')) returns contents of tf_resolution as a double
end

%% Executes during object creation, after setting all properties.
function tf_resolution_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_resolution (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end

%% Executes on selection change in cb_size.
function cb_size_Callback(hObject, eventdata, handles)
% hObject    handle to cb_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns cb_size contents as cell array
%        contents{get(hObject,'Value')} returns selected item from cb_size
handles.config.size = get(handles.cb_size, 'Value');
guidata(hObject, handles);
reportCaller('guidata');
end

%% --- Executes during object creation, after setting all properties.
function cb_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cb_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


%% --- Executes on button press in b_advanced.
function b_advanced_Callback(hObject, eventdata, handles)
% hObject    handle to b_advanced (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hAdv = AdvConfig({'parent'}, handles.guiFigure);
end


%% --- Executes on button press in rb_displayResult.
function rb_displayResult_Callback(hObject, eventdata, handles)
% hObject    handle to rb_displayResult (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rb_displayResult
end

%% --- Executes on button press in rb_manual.
function rb_manual_Callback(hObject, eventdata, handles)
% hObject    handle to rb_manual (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rb_manual
end


%% --- Executes on button press in b_compute.
function b_compute_Callback(hObject, eventdata, handles)
% hObject    handle to b_compute (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%if handles.status==1
if getappdata(handles.guiFigure, 'status')==1
    return;
end

%first save config
config = gatherConfig(handles);
if isempty(config.startfolder)
    %alert
    disp('need to select start folder');
    return;
end
save('config.mat', 'config');
handles.config = config;

setStatus(1, handles);

%guidata(hObject, handles);
%    reportCaller('guidata');

returnStatus = doCompute(handles);
%handles = guidata(hObject);
%handles = setStatus(returnStatus, handles);
%guidata(hObject, handles);
end


%% --- Executes on button press in b_format.
function b_format_Callback(hObject, eventdata, handles)
% hObject    handle to b_format (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
outputResults(handles.compResult, handles.config.startfolder, handles.config.outfile);
reformatResult(handles.compResult, handles.config.startfolder, handles.config.formatout);
msgbox(['Formated results are written to file ', ...
    [handles.config.startfolder, filesep, handles.config.formatout], ...
    '. Full results are in ' ...
    [handles.config.startfolder, filesep, handles.config.outfile], ...
    '. Please go to Advanced Configuration for changing file destination']);
end

%% --- Executes on button press in b_close.
function b_close_Callback(~, ~, handles)
% hObject    handle to b_close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%TODO
close(handles.guiFigure);
end

%% --- Executes on button press in rb_folder.
function rb_folder_Callback(hObject, eventdata, handles)
% hObject    handle to rb_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rb_folder
end

%% --- Executes during object creation, after setting all properties.
function uipanel1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

end


%% --- Executes on button press in b_loadconfig.
function b_loadconfig_Callback(hObject, ~, handles)
loadConfig(hObject, handles)
end

%%
function loadConfig(hObject, handles)
% hObject    handle to b_loadconfig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
config = readConfig();
if ~isempty(config)
    d = guidata(hObject);
    d.config = config;
    guidata(hObject, d);
    reportCaller('guidata');
    
    gui_config(config, handles);
end

end



%% --- Executes on button press in b_pause.
function b_pause_Callback(hObject, ~, handles)
% hObject    handle to b_pause (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%disp(['paused flag is currently: ', num2str(getappdata(handles.b_pause, 'paused')==1)]);

%if handles.status ~= 1 && handles.status ~= 1.1
st = getappdata(handles.guiFigure, 'status');
if st~=1 && st~=1.1 && st~=2
    return;
end

if getappdata(handles.b_pause, 'paused')==0
    setappdata(handles.b_pause, 'paused', 1);
    %setStatus(1.1, handles);  %wait for doCompute loop for exit on it's own
    %guidata(hObject, handles);
else
    setappdata(handles.b_pause, 'paused', 0);
    %handles = setStatus(1, handles);
    returnStatus = doCompute(handles);
    %setStatus(returnStatus, handles);
    %guidata(hObject, handles);
    %reportCaller('guidata, continue');
end

end

%% --- Executes when selected cell(s) is changed in tb_image.
function tb_image_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to tb_image (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)
if isempty(eventdata.Indices) return; end
idx = eventdata.Indices(1);
ret = displayResult(idx, handles);
if ret==0 return; end
handles.currentResult = idx;
guidata(hObject, handles);
reportCaller('guidata');
end

%%
function manualInit(hObject, handles)
initstatus = getappdata(handles.guiFigure, 'status')
try
    displayMode(handles, 1);
    idx = handles.currentResult;
    %load
    entry = handles.compResult(idx, :);
    if exist(entry{10}, 'file')  %whether adj exists
        orig = imread(entry{10});
    else
        orig = imread([entry{1}, filesep, entry{2}]);
    end
    [p1, p2, p3] = fileparts(entry{2});
    %display and compute
    axes(handles.ax_one);
    
    [I3, r] = manualInGUI(orig, handles.config, entry{1},p2, p3 );
    
    %fix results
    if exist(entry{10}, 'file')
        r.adjfile = entry{10};
    end
    
    r.qa = [entry{1}, '\', p2, handles.config.qc];
    
    %output
    if (endsWith(lower(r.qa), 'jpg'))
        imwrite(I3, r.qa, 'JPEG', 'Quality', 85);
    else
        imwrite(I3, r.qa);
    end
    handles.compResult(idx,:)= {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity, r.goodResult};
    guidata(hObject, handles);
    reportCaller('guidata');
    
    
    updateResult(idx, handles);
    displayResult(idx, handles, orig, I3 );
catch err
    if initstatus==2
        setStatus(2, handles);
    end
    disp(err.message)

end
end

%% --- Executes on button press in b_manual.
function b_manual_Callback(hObject, ~, handles)
% hObject    handle to b_manual (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isfield(handles, 'currentResult')
    return;
end

manualInit(hObject, handles);

end
%%
function displayMode(handles, mode)
set(handles.l_currentImage, 'String', '');
switch(mode)
    case 1 % single display
        cla(handles.ax_orig);
        cla(handles.ax_res);
        set(handles.ax_orig, 'Visible', 'off');
        set(handles.ax_res, 'Visible', 'off');
        set(handles.ax_one, 'Visible', 'on');
    case 0 % result display
        cla(handles.ax_one);
        set(handles.ax_orig, 'Visible', 'on');
        set(handles.ax_res, 'Visible', 'on');
        set(handles.ax_one, 'Visible', 'off');
end

end


%% --- Executes on button press in b_handdrawn.
function b_handdrawn_Callback(hObject, eventdata, handles)
% hObject    handle to b_handdrawn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isfield(handles, 'currentResult')
    return;
end
doHandDraw(hObject, eventdata, handles);
end

function doHandDraw(hObject, eventdata, handles)

initstatus = getappdata(handles.guiFigure, 'status');
try
    coef = handles.config.shrink;
    conv = handles.config.resolution;
    
    displayMode(handles, 1);
    idx = handles.currentResult;
    %load
    entry = handles.compResult(idx, :);
    if exist(entry{10}, 'file')  %whether adj exists
        orig = imread(entry{10});
    else
        orig = imread([entry{1}, filesep, entry{2}]);
    end
    [p1, p2, p3] = fileparts(entry{2});
    %display and compute
    axes(handles.ax_one);
    %%todo
    I2 = imresize(orig, 1/coef);
    if size(I2, 3)==3
        I2 = rgb2gray(I2);
    end
    imshow(I2);
    
    setStatus(2.2, handles);
    %msgbox('Aften click ok on this box, please proceed to the image and hand draw outline of the spheroid.', 'modal');
    
    axes(handles.ax_one);
    e = imfreehand;
    bw = createMask(e);
    a = regionprops(bw, 'all');
    if length(a)==0
        error('please draw a contour');
    end
    
    r.goodResult = true;
    r.PArea       = a(1).Area*coef*coef;
    r.PMajorAxis  = a(1).MajorAxisLength*coef;
    r.PMinorAxis  = a(1).MinorAxisLength*coef;
    r.RArea       = a(1).Area*coef*coef*conv*conv;
    r.RMajorAxis  = a(1).MajorAxisLength*coef*conv;
    r.RMinorAxis  = a(1).MinorAxisLength*coef*conv;
    r.Eccentricity = a(1).Eccentricity;
    r.V   = .5e-9*a(1).MinorAxisLength*a(1).MinorAxisLength*a(1).MajorAxisLength()*((coef*conv)^3);
    r.folder = entry{1};
    r.fn = entry{2};
    %r.complete = 1;
    
    %fix results
    if exist(entry{10}, 'file')
        r.adjfile = entry{10};
    else
        r.adjfile = '';
    end
    
    r.qa = [entry{1}, '\', p2, handles.config.qc];
    
    %output
    seg = edge(bw);
    I3 = zeros(size(I2, 1), size(I2, 2), 3);
    I3(:, :, 1) = uint8(I2)+uint8(256*seg);
    I3(:, :, 2) = uint8(I2)-uint8(256*seg);
    I3(:, :, 3) = uint8(I2)-uint8(256*seg);
    I3 = uint8(I3);
    
    if (endsWith(lower(r.qa), 'jpg'))
        imwrite(I3, r.qa, 'JPEG', 'Quality', 85);
    else
        imwrite(I3, r.qa);
    end
    
    handles.compResult(idx,:)= {r.folder, r.fn, r.V, r.PArea, r.PMajorAxis, r.PMinorAxis, r.RArea, r.RMajorAxis, r.RMinorAxis, r.adjfile, r.qa, r.Eccentricity, r.goodResult};
    guidata(hObject, handles);
    reportCaller('guidata');
    
    updateResult(idx, handles);

    displayResult(idx, handles, orig, I3 );
    
    setStatus(2, handles);
    
catch err
    if initstatus==2
        setStatus(2, handles);
    end
    rethrow(err)
end
end

%% --- Executes on button press in b_export.
function b_export_Callback(~, ~, handles)
% hObject    handle to b_export (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[file, path] = uiputfile('*.mat', 'Export To Intermediate File');
if file==0  %TODO check cancel
    return;
end
doExport([path, filesep, file], handles)
end

%%
function doExport(file, handles)
%export config, files, compResult,
config = handles.config;
compResult = handles.compResult;
filelist = handles.filelist;
result = handles.result;
%status = handles.status;
status = getappdata(handles.guiFigure, 'status');
save(file, 'config', 'compResult', 'filelist', 'result', 'status');
end

%% --- Executes on button press in b_midImport.
function b_midImport_Callback(~, ~, handles)
% hObject    handle to b_midImport (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[file, path] = uigetfile('*.mat', 'Import Intermediate File');
if isempty(file)
    return
end

load([path, filesep, file]);
handles.config = config;
handles.filelist = filelist;
handles.result = result;
handles.compResult = compResult;
guidata(handles.guiFigure, handles);
reportCaller('guidata');

%update status

if isfield(handles, 'compStatus') && status==0 %shouldn't be
    status==1.1;
end
    
if status==1  %compute into pause
    status = 1.1;
end

if status==2.2 || status == 2.1 %hand draw to review
    status = 2;
end

setStatus(status, handles);

set(handles.ta_progress, 'String', 'Intermediate results loaded.');
set(handles.tb_image, 'Data', handles.compResult(:, [1,2,3,8, 9,13]));
guidata(handles.guiFigure, handles);

reportCaller('guidata import');
end

%% --- Executes when entered data in editable cell(s) in tb_image.
function tb_image_CellEditCallback(~, eventdata, handles)
% hObject    handle to tb_image (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) edited
%	PreviousData: previous data for the cell(s) edited
%	EditData: string(s) entered by the user
%	NewData: EditData or its converted form set on the Data property. Empty if Data was not changed
%	Error: error string when failed to convert EditData to appropriate value for Data
% handles    structure with handles and user data (see GUIDATA)
if isempty(eventdata.Indices) return; end

if getappdata(handles.guiFigure, 'dataEditCallBack')=='0'  %call back turned off
    disp('clicking too fast...');
    return;
end

loc = eventdata.Indices;
if loc(2)==6 %valid
    toggleValidity(handles, loc(1));
end
end

%%
function toggleValidity(handles, loc)
setappdata(handles.guiFigure, 'dataEditCallBack', '0'); %turn off call back

%i = handles.compResult{loc(1), 13}
handles.compResult{loc, 13} = ~handles.compResult{loc, 13};

updateResult(loc, handles);

guidata(handles.guiFigure, handles);
reportCaller('guidata editcell');

setappdata(handles.guiFigure, 'dataEditCallBack', '1'); %turn call back back on

end

%%
function updateResult(idx, handles)
%update result of idx'th cell in handles into gui display

%1 get table handle
scrollPane = findjobj(handles.tb_image);
jtable = scrollPane.getViewport.getView;

%2 turn off flag
setappdata(handles.guiFigure, 'dataEditCallBack', '0');

%3 put in new data
%jtable setValueAt does not work at all
set(handles.tb_image, 'Data', handles.compResult(:, [1,2,3,8,9,13]));
pause(.2);

%jtable.setRowSelectionAllowed(0);
%jtable.setColumnSelectionAllowed(0);
%pause(.5)
jtable.changeSelection(idx-1,1, false, false);
%pause(.5)
jtable.grabFocus();

% 4 turn on flag
setappdata(handles.guiFigure, 'dataEditCallBack', '1');
end
%%
% --- Executes when user attempts to close guiFigure.
function guiFigure_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to guiFigure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
try
    doExport(['~tmp',datestr(now, 'dd-mmm-yyyy-HH-MM-SS'),'.mat'] , handles);
catch error
    %disp(error)
end

delete(hObject);

end

%% --- Executes on button press in rb_display.
function rb_display_Callback(hObject, eventdata, handles)
% hObject    handle to rb_display (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rb_display

end

function selectResult(idx, handles)

% get table handle
scrollPane = findjobj(handles.tb_image);
jtable = scrollPane.getViewport.getView;

% selection
jtable.changeSelection(idx-1,1, false, false);
jtable.grabFocus();
end

%% --- Executes on key press with focus on tb_image and none of its controls.
function tb_image_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to tb_image (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
if ~isfield(handles, 'compResult') %no result
    return;
end

switch(eventdata.Character)
    case 'v' %toggle valid
        if isfield(handles, 'currentResult')
            toggleValidity(handles, handles.currentResult);
        end
    case 'n' %next invalid
        if isfield(handles, 'currentResult')
            c = handles.currentResult;
        else %no current result
            c = 0;
        end
        n = size(handles.compResult, 1);
        if c == n %already last
            return;
        end
        for i = (c+1):n
            if ~handles.compResult{i,13}
                selectResult(i, handles);
                break;
            end
        end
    case 'm' %manual init
        manualInit(hObject, handles);
    case 'h' %hand draw
        doHandDraw(hObject, eventdata, handles);
end
end

%% --- Executes on key press with focus on b_manual and none of its controls.
function b_manual_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to b_manual (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
eventdata
end
