%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%

classdef FileList < handle
%keeps a list of files to be processed and update on where the computation
%has carried through
    properties
        status = -1;
        alloc = 0;  %allocated
        size = 0;   %actual size
        compute = 0; %currently being computed
        list = [];
        eventMessage = '';
    end
    events
        progress
    end
    methods
        function FL = FileList()
            FL.status = 0;
            expand(FL);
        end
        
        function msg = getEventMessage(FL)
            msg = FL.eventMessage;
        end
        
        function file = computing(FL, compute)
            FL.status = 2;
            FL.compute = compute;
            file = FL.list(compute);
        end
        
        %expand file list to allocate for another [incr] files
        function expand(FL)
            incr = 100;
            FL.alloc = FL.alloc+incr;
            FL.list(FL.alloc).al = 1;
        end
        
        function f = getFile(FL, idx)
            f = FL.list(idx);
        end
        
        function addFile(FL, directory, file)
            FL.status = 1;
            %disp(['add file ', directory, filesep, file]);
            if FL.size==FL.alloc
                expand(FL);
            end
            s = FL.size+1;
            FL.list(s).directory = directory;
            FL.list(s).file = file;
            FL.size = s;
        end
        
        
        function readFolder(FL, config)
            folder = config.startfolder;
            processDir(FL, folder, config.subfolder);
            
            %process directory to include all files
            function processDir(FL, folder, subfolder)
                
                files = dir(folder);
                disp(['exploring folder... ', folder]);
                for i = 1:length(files)
                    f = files(i);
                    if f.isdir && subfolder==1
                        if subfolder && f.name(1)~='.'
                            processDir(FL, [folder, filesep, f.name], 1);
                        end
                    else
                        if includeFile(f.name)
                            addFile(FL, folder, f.name);
                        end
                    end
                    
                end
                FL.eventMessage = [num2str(FL.size) ' files after processing ' folder];
                notify(FL, 'progress');
                %notify(FL, 'progress', [num2str(FL.size) ' files after processing ' folder]);
                pause(.2);
            end
            
            %judge whether the file should be included
            function includes = includeFile(name)
                incl = config.includetype;
                excl = config.excludetype;
                
                includes = false;
                for i = 1:length(incl)
                    if endsWith(lower(name), incl{i})
                        includes = true;
                        break;
                    end
                end
                if ~includes
                    return;
                end
                
                for i = 1:length(excl)
                    if endsWith(lower(name), excl{i})
                        includes = false;
                        return;
                    end
                end
                
                return;
            end
        end
    end
end