%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%
function failed = validateFiles(filelist)
% go through each item in filelist, reorganize desired value into plate
% format
% warn and skip when file can not be parsed.

failed = cell(0);

%go through filelist, process each file
ss = filelist.size;
for i = 1:ss
    f = process(filelist.getFile(i));
    if ~isempty(f)
        failed = [failed, f];
    end
end


% operates on each image, assign desired value to A(i).v(y, x)
function fn = process(F)

[plate, well, x, y] = parseFile(F.file);

if isempty(plate) || isempty(well) 
    fn = [F.directory, filesep, F.file];
    disp(['error parsing filename ', fn]);
    return;
end

fn = [];


