%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors are referenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%
function A = reformatResult(R, folder, out)
% go through each item in R, reorganize desired value into plate
% format
% warn and skip when file can not be parsed.
global A

A = [];

%go through results, process each file
ss = size(R, 1);
for i = 1:ss
    V = R{i, 3};   
    F = [R{i, 1}, filesep, R{i, 2}];
    if R{i, 13}
        process(V, F);
    end
    
end

fid2 = fopen([folder, filesep, out], 'w');
if fid2<0 disp('Cannot open output file for writing.'); end

for i = length(A):-1:1;
    fprintf(fid2, '\n\n%s\n  ',  A(i).plate);
    v = A(i).v;
    
    [h, w] = size(v);
    
    for x = 1:w
        fprintf(fid2, '\t%d', x);
    end
    
    for y = 1:h
        fprintf(fid2, '\n%c', ('a'+y-1));
        for x = 1:w
            if v(y,x) == 0
                fprintf(fid2, '\t');
            else
                fprintf(fid2, '\t%5.4f', v(y, x));
            end
        end
    end
    
    %print to screen
    disp(A(i).plate);
    disp(v);
end
fclose(fid2);

% operates on each image, assign desired value to A(i).v(y, x)
function process(v, F)

global A

l = length(A);

[plate, well, x, y] = parseFile(F);

if isempty(plate) || isempty(well)
    disp(['error parsing filename ', F]);
    return;
end

% assign value to existing plate
for i = 1:l
    if strcmp(plate, A(i).plate)
        A(i).v(y, x) = v;
        return;
    end
end

% create new plate and assign value
a = [];
a.plate = plate;
a.v(y, x) = v;
A = [a, A];
disp(['new plate: ', plate]);

