%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%


function [I3, out] = manualInGUI(orig, config, folder, fn, ext)
% folder is the root folder for scan
% fout is the output file under folder
% init_d is the seed size for level set, it should adjust according
%        to object size and shrink
% shrink is used to shrink the images for analysis
% conversion is the resolution coefficient in micron/pixel

[I3, out] = processFile(orig, config.shrink, config.resolution, folder, fn, ext);



function [I3, out] = processFile(orig, coef, conv, folder, fn, ext)

I = orig;
D = size(I, 3);

I2 = imresize(I, 1/coef);
out= struct('folder', '', 'fn', '', 'goodResult', '', 'V', 0, 'PArea', 0, 'PMajorAxis', 0, 'PMinorAxis', 0, 'RArea', 0, 'RMajorAxis', 0, 'RMinorAxis', 0, 'adjfile', '', 'qa', '', 'Eccentricity', 0);

imshow(I2)
e = imellipse;
bw = createMask(e);


[seg, phi, its] = chanvese(I2, bw, 300, .8, 12, 'r', 0);


a = regionprops(seg, 'all');
switch length(a)
    case 0   %nothing found, print all 0
        out.goodResult = 0;
        out.PArea = 0;
        out.PMajorAxis = 0;
        out.PMinorAxis = 0;
        out.RArea = 0;
        out.RMajorAxis = 0;
        out.RMinorAxis = 0;
        out.Eccentricity = 0;
        out.V = 0;
        out.folder = folder;
        out.fn = [fn,  ext];
        
    case 1   %only one found print
        out.goodResult = true;
        out.PArea       = a(1).Area*coef*coef;
        out.PMajorAxis  = a(1).MajorAxisLength*coef;
        out.PMinorAxis  = a(1).MinorAxisLength*coef;
        out.RArea       = a(1).Area*coef*coef*conv*conv;
        out.RMajorAxis  = a(1).MajorAxisLength*coef*conv;
        out.RMinorAxis  = a(1).MinorAxisLength*coef*conv;
        out.Eccentricity = a(1).Eccentricity;
        out.V   = .5e-9*a(1).MinorAxisLength*a(1).MinorAxisLength*a(1).MajorAxisLength()*((coef*conv)^3);
        out.folder = folder;
        out.fn = [fn,  ext];

    otherwise %more than one found, use largest
        %a = regionprops(seg, {'Area', 'MajorAxisLength', 'MinorAxisLength', 'PixelIdxList', 'Eccentricity'});
        maxarea = 0;
        maxitem = [];
        for i = 1:size(a)
            x = a(i);
            if x.Area>maxarea
                maxarea = x.Area;
                maxitem=x;
            end
        end

        seg(:) = 0;
        seg(maxitem.PixelIdxList) = 1;

        out.goodResult = 0;
        out.PArea       = maxitem.Area*coef*coef;
        out.PMajorAxis  = maxitem.MajorAxisLength*coef;
        out.PMinorAxis  = maxitem.MinorAxisLength*coef;
        out.RArea       = maxitem.Area*coef*coef*conv*conv;
        out.RMajorAxis  = maxitem.MajorAxisLength*coef*conv;
        out.RMinorAxis  = maxitem.MinorAxisLength*coef*conv;
        out.Eccentricity = maxitem.Eccentricity;
        out.V   = .5e-9*maxitem.MinorAxisLength*maxitem.MinorAxisLength*maxitem.MajorAxisLength()*((coef*conv)^3);
        out.folder = folder;
        out.fn = [fn, ext];
end
out.complete = 1;

seg = edge(seg);
if D==3
    I3 = I2;
    I3(:, :, 1)=I3(:, :, 1)+uint8(256*seg);
    I3(:, :, 2)=I3(:, :, 2)-uint8(256*seg);
    I3(:, :, 3)=I3(:, :, 3)-uint8(256*seg);
else    I3 = zeros(size(I2, 1), size(I2, 2), 3);
    I3(:, :, 1) = uint8(I2)+uint8(256*seg);
    I3(:, :, 2) = uint8(I2)-uint8(256*seg);
    I3(:, :, 3) = uint8(I2)-uint8(256*seg);
    I3 = uint8(I3);
end
%imshow(I3);

%imwrite(I3, [folder, '\', fn, '_crude.jpg']);
% 
% a = regionprops(seg, 'all');
% 
% if length(a)==1
%     fprintf(fid, '%d\t%f\t%f\t%f\t%f\t%f\t%s\n', ...
%         a(1).Area*coef*coef, ...
%         a(1).MajorAxisLength*coef, ...
%         a(1).MinorAxisLength*coef,  ...
%         a(1).Area*coef*coef*conv*conv, ...
%         a(1).MajorAxisLength*coef*conv, ...
%         a(1).MinorAxisLength*coef*conv,  ...
%         [folder, '\', fn]);
%     
% else
%     fprintf(fid, '%d\t%d\t%d\t%d\t%d\t%d\t%s\n', -1, -1, -1, -1, -1, -1, [folder, '\', fn]);
% end



