%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%

function varargout = AdvConfig(varargin)
% ADVCONFIG MATLAB code for AdvConfig.fig
%      ADVCONFIG, by itself, creates a new ADVCONFIG or raises the existing
%      singleton*.
%
%      H = ADVCONFIG returns the handle to a new ADVCONFIG or the handle to
%      the existing singleton*.
%
%      ADVCONFIG('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ADVCONFIG.M with the given input arguments.
%
%      ADVCONFIG('Property','Value',...) creates a new ADVCONFIG or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before AdvConfig_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to AdvConfig_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help AdvConfig

% Last Modified by GUIDE v2.5 13-Jun-2013 15:14:43

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @AdvConfig_OpeningFcn, ...
                   'gui_OutputFcn',  @AdvConfig_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

%this is only called after all the createFcns are executed.  
% call AdvConfig({'parent'}, parenthandle)
if strcmp(varargin{1}, 'parent')
    handles = guidata(varargout{1});
    handles.parent = varargin{2};
    guidata(varargout{1}, handles);
    h = guidata(varargin{2});
    setConfig(h.config, handles);
    
    %hp = guidata(handles.parent);
    %disp(hp)
end

% --- Executes just before AdvConfig is made visible.
function AdvConfig_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to AdvConfig (see VARARGIN)

% Choose default command line output for AdvConfig
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes AdvConfig wait for user response (see UIRESUME)
% uiwait(handles.guiFigure);


% --- Outputs from this function are returned to the command line.
function varargout = AdvConfig_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in b_ok.
function b_ok_Callback(hObject, eventdata, handles)
% hObject    handle to b_ok (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[success, newparenthandle] = gatherConfig(handles, guidata(handles.parent));
if success
    guidata(handles.parent, newparenthandle);
    close(handles.guiFigure);
    h = guidata(handles.parent);
    config = h.config;
    save('config.mat', 'config');
end

% --- Executes on button press in b_cancel.
function b_cancel_Callback(hObject, eventdata, handles)
% hObject    handle to b_cancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(handles.guiFigure);


function tf_format_Callback(hObject, eventdata, handles)
% hObject    handle to tf_format (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_format as text
%        str2double(get(hObject,'String')) returns contents of tf_format as a double


% --- Executes during object creation, after setting all properties.
function tf_format_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_format (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_reduce_Callback(hObject, eventdata, handles)
% hObject    handle to tf_reduce (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_reduce as text
%        str2double(get(hObject,'String')) returns contents of tf_reduce as a double


% --- Executes during object creation, after setting all properties.
function tf_reduce_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_reduce (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_include_Callback(hObject, eventdata, handles)
% hObject    handle to tf_include (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_include as text
%        str2double(get(hObject,'String')) returns contents of tf_include as a double


% --- Executes during object creation, after setting all properties.
function tf_include_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_include (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_exclude_Callback(hObject, eventdata, handles)
% hObject    handle to tf_exclude (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_exclude as text
%        str2double(get(hObject,'String')) returns contents of tf_exclude as a double


% --- Executes during object creation, after setting all properties.
function tf_exclude_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_exclude (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_adj_Callback(hObject, eventdata, handles)
% hObject    handle to tf_adj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_adj as text
%        str2double(get(hObject,'String')) returns contents of tf_adj as a double


% --- Executes during object creation, after setting all properties.
function tf_adj_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_adj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_qc_Callback(hObject, eventdata, handles)
% hObject    handle to tf_qc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_qc as text
%        str2double(get(hObject,'String')) returns contents of tf_qc as a double


% --- Executes during object creation, after setting all properties.
function tf_qc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_qc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in cb_specialcolor.
function cb_specialcolor_Callback(hObject, eventdata, handles)
% hObject    handle to cb_specialcolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns cb_specialcolor contents as cell array
%        contents{get(hObject,'Value')} returns selected item from cb_specialcolor


% --- Executes during object creation, after setting all properties.
function cb_specialcolor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cb_specialcolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in cb_parallel.
function cb_parallel_Callback(hObject, eventdata, handles)
% hObject    handle to cb_parallel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of cb_parallel



function tf_nworker_Callback(hObject, eventdata, handles)
% hObject    handle to tf_nworker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_nworker as text
%        str2double(get(hObject,'String')) returns contents of tf_nworker as a double


% --- Executes during object creation, after setting all properties.
function tf_nworker_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_nworker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_maskcolor_Callback(hObject, eventdata, handles)
% hObject    handle to tf_maskcolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_maskcolor as text
%        str2double(get(hObject,'String')) returns contents of tf_maskcolor as a double


% --- Executes during object creation, after setting all properties.
function tf_maskcolor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_maskcolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_centercolor_Callback(hObject, eventdata, handles)
% hObject    handle to tf_centercolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_centercolor as text
%        str2double(get(hObject,'String')) returns contents of tf_centercolor as a double


% --- Executes during object creation, after setting all properties.
function tf_centercolor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_centercolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in cb_plateformat.
function cb_plateformat_Callback(hObject, eventdata, handles)
% hObject    handle to cb_plateformat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns cb_plateformat contents as cell array
%        contents{get(hObject,'Value')} returns selected item from cb_plateformat


% --- Executes during object creation, after setting all properties.
function cb_plateformat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cb_plateformat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%used to convert cell array in included and excluded to string form
function a = assemble(source, exclude)
a = [];
for e = source
    excluded = 0;
    for ex = exclude
        if strcmp(e, ex)==1
            excluded = 1;
            break;
        end
    end
    if excluded continue; end
    a = [a ';' e{1}];
end
a(1)=[];
%disp(a);

%%find matching index in a cell array of strings
function i = matchIndex(strings, str)

for i = 1:length(strings)
    if strcmp(strings{i}, str)==1
        return;
    end
end

i=-1;
return

%%set configs into GUI
function setConfig(config, handles)
set(handles.tf_format, 'String', config.formatout);
set(handles.tf_reduce, 'String', num2str(config.shrink));
set(handles.tf_adj, 'String', config.adj);
set(handles.tf_qc, 'String', config.qc);
set(handles.tf_include, 'String', assemble(config.includetype, {}));
set(handles.tf_exclude, 'String', assemble(config.excludetype, {config.adj, config.qc}));
set(handles.tf_outfile, 'String', config.outfile);
set(handles.cb_specialcolor, 'Value', matchIndex(get(handles.cb_specialcolor, 'String'), config.specialcolor));  %to be verified

%set(handles.cb_plateformat, 'Value', config.plate);
%config.plate = get(handles.cb_plateformat, 'Value');

%config.centercolor = get(handles.tf_centercolor, 'String');
%config.maskcolor = get(handles.tf_maskcolor, 'String');

set(handles.cb_parallel, 'Value', config.parallel);
set(handles.tf_nworker, 'String', num2str(config.nworker));

%%gather configuration and send to parent
function [success, phandles] = gatherConfig(handles, phandles)
config = phandles.config;
config.formatout = get(handles.tf_format, 'String');
config.outfile = get(handles.tf_outfile, 'String');

[config.shrink, status] = str2num(get(handles.tf_reduce, 'String'));
if ~status
    success = 0;
    return;
end

config.adj = get(handles.tf_adj, 'String');
config.qc = get(handles.tf_qc, 'String');

config.includetype = regexp(get(handles.tf_include, 'String'), ';', 'split');
config.excludetype = regexp(get(handles.tf_exclude, 'String'), ';', 'split');
config.excludetype = [{config.adj}, {config.qc}, config.excludetype];

specialcolor = get(handles.cb_specialcolor, 'String');
icolor = get(handles.cb_specialcolor, 'Value');
config.specialcolor = specialcolor{icolor}; %get(handles.cb_specialcolor, 'Value');

[config.nworker, status] = str2num(get(handles.tf_nworker, 'String'));
if ~status
    success = 0;
    return;
end

config.plate = get(handles.cb_plateformat, 'Value');

config.centercolor = get(handles.tf_centercolor, 'String');
config.maskcolor = get(handles.tf_maskcolor, 'String');

config.parallel = get(handles.cb_parallel, 'Value');

success = 1;
phandles.config = config;
guidata(phandles.guiFigure, phandles);



function tf_outfile_Callback(hObject, eventdata, handles)
% hObject    handle to tf_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf_outfile as text
%        str2double(get(hObject,'String')) returns contents of tf_outfile as a double


% --- Executes during object creation, after setting all properties.
function tf_outfile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
