#!/bin/csh

echo "#################################################################"
echo "Copy surfaces and volumes to model directory. Create 3dslicer settings file (importsurface.mrml)"
echo "#################################################################"

echo "this is the first run" > ${SCRIPTS_DIR}/${subject}.lock
mkdir ${SUBJECTS_DIR}/${subject}/MODEL
cd  ${SUBJECTS_DIR}/${subject}/MODEL





##########must be changed if you want to work with other freesurfer surfaces##########
foreach surface (lh.pial rh.pial lh.outer_skin_surface lh.outer_skull_surface)
	cp ${SUBJECTS_DIR}/${subject}/surf/${surface} .
end
##########must be changed if you want to work with other freesurfer surfaces##########





foreach volume (aseg.nii brain.nii)
	cp ${SUBJECTS_DIR}/${subject}/SUMA/${volume} .
end





##########must be changed if you want to work with other subcortical volumes##########
echo '<MRML  version="14658" userTags="">' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '<Selection' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSelectionNode1"  name="vtkMRMLSelectionNode1"  hideFromEditors="true"  selectable="true"  selected="false"  activeVolumeID="vtkMRMLScalarVolumeNode2"  secondaryVolumeID="NULL"  activeLabelVolumeID="vtkMRMLScalarVolumeNode1"  activeFiducialListID="NULL"  activeROIListID="NULL"  activeCameraID="NULL"  activeViewID="NULL"  activeLayoutID="vtkMRMLLayoutNode1"></Selection>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Interaction' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLInteractionNode1"  name="vtkMRMLInteractionNode1"  hideFromEditors="true"  selectable="true"  selected="false"  currentInteractionMode="ViewTransform"  lastInteractionMode="ViewTransform" ></Interaction>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Layout' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLLayoutNode1"  name="vtkMRMLLayoutNode1"  hideFromEditors="true"  selectable="true"  selected="false"  currentViewArrangement="2"  guiPanelVisibility="1"  bottomPanelVisibility ="1"  guiPanelLR="0"  collapseSliceControllers="0"' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  numberOfCompareViewRows="1"  numberOfCompareViewColumns="1"  numberOfLightboxRows="1"  numberOfLightboxColumns="1"  mainPanelSize="400"  secondaryPanelSize="350"  selectedModule="Model Maker" ></Layout>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <View' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLViewNode1"  name="View"  hideFromEditors="false"  selectable="true"  selected="false"  active="true"  visibility="true"  fieldOfView="200"  letterSize="0.05"  boxVisible="true"  fiducialsVisible="true"  fiducialLabelsVisible="true"  axisLabelsVisible="true"  backgroundColor="0.70196 0.70196 0.90588"  animationMode="Off"  viewAxisMode="LookFrom"  spinDegrees="2"  spinMs="5"  spinDirection="YawLeft"  rotateDegrees="5"  rockLength="200"  rockCount="0"  stereoType="NoStereo"  renderMode="Perspective" ></View>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Camera' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLCameraNode1"  name="Default Scene Camera"  hideFromEditors="false"  selectable="true"  selected="false"  position="0 500 0"  focalPoint="0 0 0"  viewUp="0 0 1"  parallelProjection="false"  parallelScale="1"  activetag="vtkMRMLViewNode1" ></Camera>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <TGParameters' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLChangeTrackerNode1"  name="vtkMRMLChangeTrackerNode1"  hideFromEditors="true"  selectable="true"  selected="false"  ROIMin="-1 -1 -1"  ROIMax="-1 -1 -1"  SegmentThresholdMin="-1"  SegmentThresholdMax="-1"  Analysis_Intensity_Flag="0"  Analysis_Deformable_Flag="0"  UseITK="1"  RegistrationChoice="3"  ROIRegistration="1"  ResampleChoice="3"  ResampleConst="0.5" ></TGParameters>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <ModelTransformNode' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelTransformNode1"  name="vtkMRMLModelTransformNode1"  hideFromEditors="true"  selectable="true"  selected="false"  transformNormals="1" ></ModelTransformNode>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <VolumeRenderingScenario' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLVolumeRenderingScenarioNode1"  name="vtkMRMLVolumeRenderingScenarioNode1"  hideFromEditors="true"  selectable="true"  selected="false"  parametersNodeID="NULL" ></VolumeRenderingScenario>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Crosshair' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLCrosshairNode1"  name="vtkMRMLCrosshairNode1"  hideFromEditors="true"  selectable="true"  selected="false"  crosshairMode="NoCrosshair"  navigation="true"  crosshairBehavior="Normal"  crosshairThickness="Fine"  crosshairRAS="0.5 -0.5 0.5" ></Crosshair>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Slice' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceNode1"  name="Green"  hideFromEditors="true"  selectable="true"  selected="false"  fieldOfView="469.389 255 1"  dimensions="497 270 1"  activeSlice="0"  layoutGridRows="1"  layoutGridColumns="1"  sliceToRAS="-1 0 0 0.5 0 0 1 -0.5 0 1 0 0.5 0 0 0 1"  layoutName="Green"  orientation="Coronal"  jumpMode="1"  sliceVisibility="false"  widgetVisibility="false"  useLabelOutline="false"  sliceSpacingMode="0"  prescribedSliceSpacing="1 1 1" ></Slice>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <SliceComposite' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceCompositeNode1"  name="vtkMRMLSliceCompositeNode1"  hideFromEditors="true"  selectable="true"  selected="false"  backgroundVolumeID="vtkMRMLScalarVolumeNode2"  foregroundVolumeID=""  labelVolumeID="vtkMRMLScalarVolumeNode1"  compositing="0"  labelOpacity="1"  linkedControl="0"  foregroundGrid="0"  backgroundGrid="0"  labelGrid="1"  fiducialVisibility="1"  fiducialLabelVisibility="1"  sliceIntersectionVisibility="0"  layoutName="Green"  annotationMode="All"  doPropagateVolumeSelection="1" ></SliceComposite>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Slice' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceNode2"  name="Red"  hideFromEditors="true"  selectable="true"  selected="false"  fieldOfView="468.444 255 1"  dimensions="496 270 1"  activeSlice="0"  layoutGridRows="1"  layoutGridColumns="1"  sliceToRAS="-1 0 0 0.5 0 1 0 -0.5 0 0 1 0.5 0 0 0 1"  layoutName="Red"  orientation="Axial"  jumpMode="1"  sliceVisibility="false"  widgetVisibility="false"  useLabelOutline="false"  sliceSpacingMode="0"  prescribedSliceSpacing="1 1 1" ></Slice>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <SliceComposite' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceCompositeNode2"  name="vtkMRMLSliceCompositeNode2"  hideFromEditors="true"  selectable="true"  selected="false"  backgroundVolumeID="vtkMRMLScalarVolumeNode2"  foregroundVolumeID=""  labelVolumeID="vtkMRMLScalarVolumeNode1"  compositing="0"  labelOpacity="1"  linkedControl="0"  foregroundGrid="0"  backgroundGrid="0"  labelGrid="1"  fiducialVisibility="1"  fiducialLabelVisibility="1"  sliceIntersectionVisibility="0"  layoutName="Red"  annotationMode="All"  doPropagateVolumeSelection="1" ></SliceComposite>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Slice' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceNode3"  name="Yellow"  hideFromEditors="true"  selectable="true"  selected="false"  fieldOfView="469.389 255 1"  dimensions="497 270 1"  activeSlice="0"  layoutGridRows="1"  layoutGridColumns="1"  sliceToRAS="0 0 1 0.5 -1 0 0 -0.5 0 1 0 0.5 0 0 0 1"  layoutName="Yellow"  orientation="Sagittal"  jumpMode="1"  sliceVisibility="false"  widgetVisibility="false"  useLabelOutline="false"  sliceSpacingMode="0"  prescribedSliceSpacing="1 1 1" ></Slice>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <SliceComposite' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLSliceCompositeNode3"  name="vtkMRMLSliceCompositeNode3"  hideFromEditors="true"  selectable="true"  selected="false"  backgroundVolumeID="vtkMRMLScalarVolumeNode2"  foregroundVolumeID=""  labelVolumeID="vtkMRMLScalarVolumeNode1"  compositing="0"  labelOpacity="1"  linkedControl="0"  foregroundGrid="0"  backgroundGrid="0"  labelGrid="1"  fiducialVisibility="1"  fiducialLabelVisibility="1"  sliceIntersectionVisibility="0"  layoutName="Yellow"  annotationMode="All"  doPropagateVolumeSelection="1" ></SliceComposite>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <CommandLineModule' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLCommandLineModuleNode1"  name="Default Sampling"  hideFromEditors="true"  selectable="true"  selected="false" title="Unknown" version="Unspecified" ></CommandLineModule>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <CommandLineModule' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLCommandLineModuleNode2"  name="Fast Sampling"  hideFromEditors="true"  selectable="true"  selected="false" title="Unknown" version="Unspecified" ></CommandLineModule>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <ScriptedModule' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLScriptedModuleNode1"  name="vtkMRMLScriptedModuleNode1"  hideFromEditors="true"  selectable="true"  selected="false" ModuleName ="Editor" parameter0= "label 1" ></ScriptedModule>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <VolumeArchetypeStorage' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLVolumeArchetypeStorageNode1"  name="vtkMRMLVolumeArchetypeStorageNode1"  hideFromEditors="true"  selectable="true"  selected="false"  fileName="aseg.nii"  useCompression="1"  readState="0"  writeState="0"  centerImage="0"  singleFile="0"  UseOrientationFromFile="1" ></VolumeArchetypeStorage>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Volume' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLScalarVolumeNode1"  name="aseg"  hideFromEditors="false"  selectable="true"  selected="false"  storageNodeRef="vtkMRMLVolumeArchetypeStorageNode1"  userTags=""  displayNodeRef="vtkMRMLLabelMapVolumeDisplayNode1"  ijkToRASDirections="-1   0   -0 0   -0   1 -0 -1 -0 "  spacing="1 1 1"  origin="128 -128 128"  labelMap="1" ></Volume>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <LabelMapVolumeDisplay' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLLabelMapVolumeDisplayNode1"  name="vtkMRMLLabelMapVolumeDisplayNode1"  hideFromEditors="true"  selectable="true"  selected="false"  color="0.5 0.5 0.5"  selectedColor="1 0 0"  selectedAmbient="0.4"  ambient="0"  diffuse="1"  selectedSpecular="0.5"  specular="0"  power="1"  opacity="1"  visibility="true"  clipping="false"  sliceIntersectionVisibility="false"  backfaceCulling="true"  scalarVisibility="false"  vectorVisibility="false"  tensorVisibility="false"  autoScalarRange="true"  scalarRange="0 100"  colorNodeRef="vtkMRMLColorTableNodeFileGenericColors.txt"  ></LabelMapVolumeDisplay>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <VolumeArchetypeStorage' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLVolumeArchetypeStorageNode2"  name="vtkMRMLVolumeArchetypeStorageNode2"  hideFromEditors="true"  selectable="true"  selected="false"  fileName="brain.nii"  useCompression="1"  readState="0"  writeState="0"  centerImage="0"  singleFile="0"  UseOrientationFromFile="1" ></VolumeArchetypeStorage>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Volume' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLScalarVolumeNode2"  name="brain"  hideFromEditors="false"  selectable="true"  selected="false"  storageNodeRef="vtkMRMLVolumeArchetypeStorageNode2"  userTags=""  displayNodeRef="vtkMRMLScalarVolumeDisplayNode1"  ijkToRASDirections="-1   0   -0 0   -0   1 -0 -1 -0 "  spacing="1 1 1"  origin="128 -128 128"  labelMap="0" ></Volume>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <VolumeDisplay' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLScalarVolumeDisplayNode1"  name="vtkMRMLScalarVolumeDisplayNode1"  hideFromEditors="true"  selectable="true"  selected="false"  color="0.5 0.5 0.5"  selectedColor="1 0 0"  selectedAmbient="0.4"  ambient="0"  diffuse="1"  selectedSpecular="0.5"  specular="0"  power="1"  opacity="1"  visibility="true"  clipping="false"  sliceIntersectionVisibility="false"  backfaceCulling="true"  scalarVisibility="false"  vectorVisibility="false"  tensorVisibility="false"  autoScalarRange="true"  scalarRange="0 100"  colorNodeRef="vtkMRMLColorTableNodeGrey"   window="150"  level="75"  upperThreshold="32767"  lowerThreshold="-32768"  interpolate="1"  autoWindowLevel="1"  applyThreshold="0"  autoThreshold="0" ></VolumeDisplay>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <FreeSurferModelStorage' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLFreeSurferModelStorageNode1"  name="vtkMRMLFreeSurferModelStorageNode1"  hideFromEditors="true"  selectable="true"  selected="false"  fileName="lh.pial"  useCompression="1"  readState="0"  writeState="0" useStripper="0" ></FreeSurferModelStorage>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <ModelDisplay' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelDisplayNode4"  name="vtkMRMLModelDisplayNode4"  hideFromEditors="true"  selectable="true"  selected="false"  color="0.5 0.5 0.5"  selectedColor="1 0 0"  selectedAmbient="0.4"  ambient="0"  diffuse="1"  selectedSpecular="0.5"  specular="0"  power="1"  opacity="1"  visibility="true"  clipping="false"  sliceIntersectionVisibility="false"  backfaceCulling="true"  scalarVisibility="false"  vectorVisibility="false"  tensorVisibility="false"  autoScalarRange="true"  scalarRange="0 100"  ></ModelDisplay>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Model' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelNode4"  name="lh.pial"  hideFromEditors="false"  selectable="true"  selected="false"  storageNodeRef="vtkMRMLFreeSurferModelStorageNode1"  userTags=""  displayNodeRef="vtkMRMLModelDisplayNode4" ></Model>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <FreeSurferModelStorage' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLFreeSurferModelStorageNode2"  name="vtkMRMLFreeSurferModelStorageNode2"  hideFromEditors="true"  selectable="true"  selected="false"  fileName="rh.pial"  useCompression="1"  readState="0"  writeState="0" useStripper="0" ></FreeSurferModelStorage>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <ModelDisplay' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelDisplayNode5"  name="vtkMRMLModelDisplayNode5"  hideFromEditors="true"  selectable="true"  selected="false"  color="0.5 0.5 0.5"  selectedColor="1 0 0"  selectedAmbient="0.4"  ambient="0"  diffuse="1"  selectedSpecular="0.5"  specular="0"  power="1"  opacity="1"  visibility="true"  clipping="false"  sliceIntersectionVisibility="false"  backfaceCulling="true"  scalarVisibility="false"  vectorVisibility="false"  tensorVisibility="false"  autoScalarRange="true"  scalarRange="0 100"  ></ModelDisplay>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <Model' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelNode5"  name="rh.pial"  hideFromEditors="false"  selectable="true"  selected="false"  storageNodeRef="vtkMRMLFreeSurferModelStorageNode2"  userTags=""  displayNodeRef="vtkMRMLModelDisplayNode5" ></Model>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <CommandLineModule' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLCommandLineModuleNode3"  name="Model Maker"  hideFromEditors="true"  selectable="true"  selected="false" title="Model%20Maker" version="3.2" InputVolume="vtkMRMLScalarVolumeNode1" ColorTable="" ModelSceneFile="vtkMRMLModelHierarchyNode1" Name="Model" GenerateAll="false" Labels="17,%2018,%2053,%2054" StartLabel="-1" EndLabel="-1" SkipUnNamed="true" JointSmoothing="false" Smooth="50" FilterType="Sinc" Decimate="0.25" SplitNormals="true" PointNormals="true" SaveIntermediateModels="false" debug="false" ></CommandLineModule>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo ' <ModelHierarchy' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '  id="vtkMRMLModelHierarchyNode1"  name="Model Maker Model"  hideFromEditors="true"  selectable="true"  selected="false"  expanded="true" ></ModelHierarchy>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
echo '</MRML>' >> ${SUBJECTS_DIR}/${subject}/MODEL/importsurface.mrml
##########must be changed if you want to work with other subcortical volumes##########


