#!/bin/csh

#########requirements
	#SUBJECTS_DIR	must have subfolders with each subject's standard freesurfer output + a SUMA directory with aseg.nii and brain.nii files
	#BRAINSTORM_DIR	must be a folder within your brainstorm_db folder. also, subjects must be created in brainstorm prior to running this script. 
	#SCRIPTS_DIR	where this script is run from. 
	#subject	this is the list of subjects that you want to run, which is defined in the 'foreach subject loop'
	#3dSlicer - 	http://www.slicer.org/
	#paraview - 	http://www.paraview.org/
	#freesurfer
	#afni
	#caveat -	this script was designed to import the folloing things into brainstorm 'outer skin surface' 'outer skull surface' 
	#		'left and right pial surfaces' 'left and right amygdala' 'left and right hippocampi'
	#		If you want to import surface models from other subcortical structures, you will need to manually make them in 
	#		slicer and paraview. You will then need to save an alternate importsurfaces.mrml file and update the 'foreach model()' loop
	#		If you want to import other freesurfer surfaces, you will need to update the 'foreach surf ()' loop


#########steps
#	1	run freesurfer - make sure that you use the options to export the outer skin and outer skull. 
#		also make sure that you convert everything to an afni usable format. 
#	2	run importsurfaces.csh - the first time you run the program it will copy all the files you need into a new 'MODEL' folder in 
#		each subject's segmentation folder. It will also create an 'importsurface.mrml' file that is used to create the surface models of 
#		the amygdala and hippocampus
#	3	create amygdala and hippocampus surfaces
#	3a	run Slicer3 importsurface.mrml from the subject's 'MODEL' directory. This will load the surfaces and volumes into 3Dslicer.
#	3b	generate models of amygdala and hippocampus, save models as XXX.ply where XXX is the label in the aseg.nii volume
#	3c	import .vtk files into paraview
#	3d	run filter "generate surface normals"
#	3e	export surface normals for amy and hipp as .ply (ascii) files
#	4	run importsurfaces.csh again - this will convert the surfaces into files that can be read by matlab.
#		it will also create a matlab script called 'importsurface.m' in the 'SCRIPTS_DIR'
#	5	run importsurface.m from matlab - this will convert the surfaces into brainstorm tess_XXX.mat files.
#		!!!!!!!!!!!!!make sure that you have already created the subject in brainstorm before copying .mat files to brainstorm folder
#	6	run importsurfaces.csh a third time - this will copy all of the tess_XXX.mat files into the 'BRAINSTORM_DIR' folder
#		!!!!!!!!!!!!!once you get the surfaces into brainstorm be sure to refresh the database

#******once you get the surfaces into brainstorm
	#import MRI from ${SUBJECTS_DIR}/mri/T1.mgz
	#manually align with MRI. 
	#I started with the scalp, then hit apply to all surfaces.
	#merge the two pial surfaces and reduce the vertices to 15000
	#merge the two hippocampal surfaces and reduce the vertices to 2000
	#merge the two amygdala surfaces and reduce the vertices to 1000
	#merge the pial, hippocampal and amygdala surfaces.
	#create scouts for the amgygdala and hippocampus. 
	#import MEG data
	#compute noise covarience from recordings
	#compute head model using overlapping spheres method with cortex as input
	#compute sources
	#run z-score normalization
	#average across runs
	#create CS+>CS- difference score
	#create modelized recordings
	#display modelized recordings for amygdala and hippocampus





##########must be changed##########
setenv subfolder /GOLGI/MEG_db/MEG_clinic/maskcond/fMRI #root folder where subjects' T1 images will be stored
setenv SUBJECTS_DIR /GOLGI/MEG_db/MEG_clinic/maskcond/fMRI/SEGMENTATION #root folder where subjects' segmented anatomy will be stored
setenv BRAINSTORM_DIR /GOLGI/MEG_db/brainstorm/maskcond/anat #root folder where brainstorm stores matlab formatted anatomy files 
setenv SCRIPTS_DIR /GOLGI/MEG_db/MEG_clinic/maskcond/SCRIPTS #folder where this script and other scripts will be stored
##########must be changed##########

foreach sub ( `ls ${subfolder}` )

setenv subject $sub

if (-e ${subfolder}/${subject}/skip ) then
	echo "${subfolder}/${subject} is not a subject directory"
else if (-e ${BRAINSTORM_DIR}/${subject}/tess_l_amy.mat) then
	echo "${subject} anatomy has been successfully exported"
else if (-e ${SCRIPTS_DIR}/${subject}.lock) then

${SCRIPTS_DIR}/step2.importsurface.csh

else

${SCRIPTS_DIR}/step1.importsurface.csh

endif
end

