#!/bin/tcsh

##########must be changed##########
setenv subfolder /GOLGI/MEG_db/MEG_clinic/maskcond/fMRI #root folder where subjects' T1 images will be stored
setenv scriptfolder /GOLGI/MEG_db/MEG_clinic/maskcond/SCRIPTS #folder where this script and other scripts will be stored
setenv SUBJECTS_DIR /GOLGI/MEG_db/MEG_clinic/maskcond/fMRI/SEGMENTATION #root folder where subjects' segmented anatomy will be stored
##########must be changed##########

foreach subject ( `ls ${subfolder}` )

echo "#################################################################"
echo "Perform freesurfer segmentation"
echo "#################################################################"

if (-e ${subfolder}/${subject}/skip ) then
	echo "${subfolder}/${subject} is not a subject directory"
else if (-e ${SUBJECTS_DIR}/${subject}/SUMA) then
	echo "${subject} segmentation complete"
else

mkdir ${SUBJECTS_DIR}/${subject}

cp ${subfolder}/${subject}/${subject}.anat+orig.* ${SUBJECTS_DIR}/${subject}/

recon-all -subject ${subject} -i ${subject}.anat+orig.BRIK -force -autorecon1 >> autorecon1.txt
recon-all -subject ${subject} -autorecon2 >> autorecon2.txt
recon-all -subject ${subject} -autorecon3 >> autorecon3.txt

mri_watershed -useSRAS -LABEL -T1 ${SUBJECTS_DIR}/${subject}/mri/T1.mgz ${SUBJECTS_DIR}/${subject}/mri/T12.mgz

rename _ lh. _*
mv lh.* surf

echo "#################################################################"
echo "Create AFNI readable files"
echo "#################################################################"

@SUMA_Make_Spec_FS \
-sid ${subject} \
-fspath ${SUBJECTS_DIR}/${subject}

endif
