; NAME:
;   mt_reduce 
; PURPOSE:
;   Takes ordered positions in a trajectory (microtubule gliding was design)
;   and averages noisy overlaping points into points spaced by about a pixel.
;   *Call mt_order.pro first.
; CALLING SEQUENCE:
;   mtr = mt_reduce(mto)
; INPUTS:
;   mto:  (nx,ny) array which  contains the ordered x and y positions of
;          tracked MT data from mt_order.pro.
; OUTPUTS:
;   mtr(0,*): this contains the reduced x positions, in pixels.
;   mtr(1,*): this contains the reduced y positions, in pixels. 
; SIDE EFFECTS:
;   None, due to some useful temporary arrays.
; RESTRICTIONS:
;   If there are mis-tracked data in mto, then the output will be 
;   garbage as well.
; PROCEDURE:
;   Average all points within 0.5 pixel of the initial point, record.  Then, jump
;   to the first point at least 1 pixel further along.  Average all points
;   within 0.5 pixel, record.  Remove first 1 pixel of points, jump another pixel
;   along, repeat.  The removal of early points makes it easier to use Where.
;
; MODIFICATION HISTORY:
;   Written by DM, 9/10
;   

; yet another simple function to reduce the microtubule to a pixel-ish thing
; I think the strategy here is to average together points within 0.5 pixel 
; of eachother every pixel or so along the MT to get a reduced MT..  Let's
; see what happens...


function mt_reduce, mtin

mto=mtin
; the first point...
w1=where(sqrt((mto(0,*)-mto(0,0))^2+(mto(1,*)-mto(1,0))^2) le 0.5, ngood)
out=[mean(mto(0,w1)), mean(mto(1,w1))]
; now, let's find the next point, at least one pixel away!
w2=where(sqrt((mto(0,*)-mto(0,0))^2+(mto(1,*)-mto(1,0))^2) ge 1, ngood)

while ngood gt 0 do begin
  w1=where(sqrt((mto(0,*)-mto(0,w2(0)))^2+(mto(1,*)-mto(1,w2(0)))^2) le 0.5)
  out=[[out],[mean(mto(0,w1)), mean(mto(1,w1))]]
  ; now, get rid of all the first points, repeat!
  mto=mto(*,w2)
  w2=where(sqrt((mto(0,*)-mto(0,0))^2+(mto(1,*)-mto(1,0))^2) ge 1, ngood)
  ; ok, I'm pretty sure this takes the new  first good point, and moves from there
endwhile

return, out

end
