; NAME:
;   mt_order 
; PURPOSE:
;   Orders points in a putative MT gliding trajectory so that they increase
;   along the lenth of the MT rather than random ordered.  Call track.pro first.
; CALLING SEQUENCE:
;   mto = mt_order(xym)
; INPUTS:
;   xym:  (nx,ny) array which presumably contains the x and y positions of
;          tracked MT data.
; OUTPUTS:
;   mto(0,*): this contains the ordered x positions, in pixels.
;   mto(1,*): this contains the ordered y positions, in pixels. 
; SIDE EFFECTS:
;   None, due to some useful temporary arrays.
; RESTRICTIONS:
;   To work properly, the microtubule trajectories should not 
;   come within 2 um of eachother.  Otherwise, multiple MT trajectories
;   will be combined.!  Nor should a given trajectory have gaps greater 
;   than 20 pixels (2 um).
; PROCEDURE:
;   First, ask user to click just off the start of the trajectory.
;   Then, find all things within 20 pixels, order by distance from that
;   initial point.  Remove those from the trajectory, start with the 
;   last point, look for all within 20 pixels, etc.  This should get 
;   all pixels into order along the MT rather than jumbled up.
;
; MODIFICATION HISTORY:
;   Written by DM, 9/10
;   
; 

; must click just off the end point to start and
; get the initial point.

function mt_order,mt,nearest=nearest,firstpoint=firstpoint
if not keyword_set(nearest) then nearest=10

xym=mt
smt=size(xym)
; an array to hold the ordered microtubule points, and the distance along the mt.
mto=xym
if not keyword_set(firstpoint) then begin
  plot,xym(0,*),xym(1,*),psym=3,/yno
  print,'please click on a point just before the beginning of the MT of interest'
  cursor,xend,yend
endif else begin
  xend=firstpoint(0) & yend=firstpoint(1)
endelse
; midx is the index of the point we care about
a=min(sqrt((xym(0,*)-xend)^2+(xym(1,*)-yend)^2),midx)
;distance from the end point.

dist1=sqrt((xym(0,*)-xym(0,midx))^2+(xym(1,*)-xym(1,midx))^2)
; look for points within 1 um, 10 pixels.
w=where(dist1 le nearest,ngood,complement=wc,ncomp=nwc)
; now start to act...
newidx=0  ; an index to set up mto..
while ngood gt 0 do begin

  s=sort(dist1(w))
;pass the good points across into mto, from the last points on..
  mto(*,newidx:newidx+ngood-1)=xym(*,w(s))
  newidx=newidx+ngood
  ; eliminiate the old, if there are any left...
  if nwc gt 0 then begin
    xym=xym(*,wc)
    dist1=sqrt((xym(0,*)-mto(0,newidx-1))^2+(xym(1,*)-mto(1,newidx-1))^2)
    w=where(dist1 le nearest,ngood,complement=wc,ncomp=nwc)
  endif else begin
    ngood=0 ; force end of while
    ;print,'ran out of MT - hooray'
  endelse
endwhile

return,mto(*,0:newidx-1)  

end