; NAME:
;   mt_mlsq
; PURPOSE:
;   Takes a series of MT trajectories and condenses them to their moving least
;   squares line (i.e. reduces spread) following Lee's 1999 paper.
; CALLING SEQUENCE:
;   out = mt_mlsq(mtt)
; INPUTS:
;   mtt:  7 by n element array of tracks generated by trajectory_maker.pro.  
;       The 6th column must contain the trajectory number, 0th and 1st the x and
;       y positions respectively.
; OUTPUTS:
;   out:  7 by n element array (same size as mtt), where the x and y positions have
;       been moved to their moving least squares positions.
; SIDE EFFECTS:
;   None known.
; RESTRICTIONS:
;   Must run on mtt array with track number stored in the last (6th) column,
;   and with x and y locations in the 0th and 1st column.  
; PROCEDURE:
;   For each trajectory, call mlsq.pro, which does all the work.  See mlsq.pro for
;   explanation, or 
;   In-Kwon Lee, Computer Aided Geometric Design   Volume 17 ,  
;   Issue 2  (February 2000) Pages: 161 - 177  section 2
;
; MODIFICATION HISTORY:
;   Written by DM, 10/10

; a simple function to reduce all trajectories to their moving least squares
; centered values..

function mt_mlsq,mtt

  ntrajs=max(mtt(6,*)) ; the number of trajectories
  out=mtt ; just keep the same size, we're just reducing...
  for i=0,ntrajs do begin ; now, for each one,...
    w=where(mtt(6,*) eq i,ngood)
    out(*,w)=mlsq(mtt(*,w)) ; I think this is reducing everything...
  endfor
  
  return,out

end
  