; NAME:
;   mt_length
; PURPOSE:
;   Takes sparse points along a trajectory and calculates the path length
;   along the trajectory.
; CALLING SEQUENCE:
;   mtl = mt_length(mtr)
; INPUTS:
;   mtr:  (nx,ny) array which contains the reduced x and y positions of
;          tracked MT data.  Must call mt_reduce.pro first.
; OUTPUTS:
;   mtl(*):  The pathlength from the start of the MT to the position in 
;            mtr at this index.
; SIDE EFFECTS:
;   None, due to some useful temporary arrays.
; RESTRICTIONS:
;   Must run on data that is ordered along the MT!
; PROCEDURE:
;   Calculate the distance (sqrt(dx^2+dy^2)) from one point to the next.  Add
;   these displacements to calculate the total displacement along the MT.
;
; MODIFICATION HISTORY:
;   Written by DM, 9/10
;   

; yet another simple function to find the pathlength along a microtubule...
; Must use after mt_reduce.  We can then just take the sum of the lengths from
; point to point to get a length along the MT!


function mt_length, mtr

sz=size(mtr)
out=fltarr(sz(2))
if sz(0) eq 1 then begin ; oops, the trajectory is only one point long!
  out = -1
endif else begin

  for i=1,sz(2)-1 do begin ; now, starting at the second point, let's move along
    ds=sqrt((mtr(0,i)-mtr(0,i-1))^2+(mtr(1,i)-mtr(1,i-1))^2) ; the path from previous to present
    out(i)=out(i-1)+ds ; just add on ds
  endfor

endelse
return, out

end
