function longer_trajectories,omt,long_enough

; a simple function to keep only those trajectories that are longer in distance
; than long_enough.  Must be ordered.  

  ntraj=max(omt(6,*)) ; the number of trajectories.
  out=fltarr(7) ; a seed array...
  idx=0
  for i=0,ntraj do begin
    
    w=where(omt(6,*) eq i)
    tk=omt(*,w) ; the track
    mtr=mt_reduce(tk)
    if (size(mtr))[0] eq 1 then begin ; oops, a 1 pixel trajectory...
      L = 1 ; 1 pixel long
    endif else begin
      mtl=mt_length(mtr)
      L = max (mtl) ; the length of the trajectory...
    endelse
    
    if L ge long_enough then begin
      tk(6,*) = idx ; a new index for this track
      out=[[out],[tk]]
      idx++
    endif
    
  endfor
  
  if size(out,/n_ele) eq 7 then begin ; oops, nothing long enough! Just the seed...
    print, 'oops, all trajctories too short'
    out=-1
  endif else begin
    out=out(*,1:*)
  endelse
  
  return, out
  
end