; NAME:
;   endfinder
; PURPOSE:
;   Finds one end (random) of a trajectory, following
;   In-Kwon Lee, Computer Aided Geometric Design  Volume 17 ,  
;   Issue 2  (February 2000) Pages: 161 - 177  section 5.
; CALLING SEQUENCE:
;   mtend = endfinder(tk,reduce=reduce)
; INPUTS:
;   tk:  A trajectory of x, y positions (in 0th and 1st columns), pre thinned by mlsq.
;   reduce:  A scalar keyword which contains the 'h' value in Lee- the distance
;     to jump when toward the end.  Must be bigger than same_track in segregate_mts.
; OUTPUTS:
;   mtend:  The x,y position of the end of the microtubule trajectory.
; SIDE EFFECTS:
;   None known.
; RESTRICTIONS:
;   Must use with tk array with x in 0th column, y in 1st column. 
;   *** WARNING: Can get stuck in infinate loop, despite my best attempts. ***
; PROCEDURE:
;   Takes a random point (ok, well, the 0th point).  Then, finds all points within
;   a distance h (9.0 pixels by default) of that point.  Finds the local tangent
;   vector at the point, and then dots that into the vector to each of the points
;   within h.  Separates those into + and - (i.e. forward and backward), and then
;   jumps to the most distant point.  The second time round, it makes sure that 
;   we move away from the previous point, stored as lastpoint.  Otherwise, the
;   danger is that we just jump back and forth infinitely.  Once we get to the
;   end of the MT, return that endpoint.

; MODIFICATION HISTORY:
;   Written by DM, 10/10

function endfinder,tk,reduce=reduce

  if keyword_set(reduce) then begin
    h=reduce
  endif else begin
    h=9 ; corresponds to range h in Lee part 5, better be bigger than distances
        ; within track and segregate_mts.pro
  endelse
  mtend=-1; a variable to hold the end spot of the MT...
  lastpoint=tk(*,0)
  tester=0
  ; first, pick the inital point, tk(*,0), and find everything within h (range)
  currentpoint=lastpoint ; same point, initially
  
; now, until we actually reach the end of the MT, let's keep moving away from both
; where we are and where we were...
  while mtend(0) eq -1 do begin
  
; first, a quick infinite loop catcher... 
; *** if this gets triggered, look at the trajectory.  It is probably disconnected,
; and may actually contain multiple tracks... 
    tester++
    if tester ge 10000 then message,'oops, got stuck without finding an end!'
    
    r=sqrt((tk(0,*)-currentpoint(0))^2+(tk(1,*)-currentpoint(1))^2)
; close by... If none, we'll need to stop anyway    
    w=where(r le h) 
    z=linfit(tk(0,w),tk(1,w)) ; a linear fit to this local region.  
    
; unit vector in the direction of the slope..    
    localvec=[[1./sqrt(1.+z(1)^2)],[z(1)/sqrt(1.+z(1)^2)]]
; displacement vector from our point to nearby       
    disp=[tk(0,w)-currentpoint(0),tk(1,w)-currentpoint(1)] 

; dot product, sign tells us which direction these points are away.    
    dp=localvec#disp 
    mx=max(dp,mxidx,min=mn,subs=mnidx); getting the max and min of the dot product, and indices
     ; the output array...
    
    ; now, did we get lucky and pick the start or end point from the very beginning?
    if mx eq 0 then begin
      ;hooray, at one end!
      mtend=currentpoint
    endif else begin
      if mn eq 0 then begin
      ; hooray, at the other end
        mtend=currentpoint
      endif else begin
; now, which direction is "forward"?  The one furthest from the previous point.
        fwd=sqrt((tk(0,w(mxidx))-lastpoint(0))^2+(tk(1,w(mxidx))-lastpoint(1))^2)
        bkwd=sqrt((tk(0,w(mnidx))-lastpoint(0))^2+(tk(1,w(mnidx))-lastpoint(1))^2)
        lastpoint=currentpoint ; putting this point into the previous position

; let's only go toward one end...  
; this expression says if fwd gt bkwd then use mxidx, otherwise use mnidx...      
        currentpoint=(fwd gt bkwd) ? tk(*,w(mxidx)):tk(*,w(mnidx)) 
      endelse
    endelse
  endwhile
  
  return, mtend

end