; dpretrack - revised version of epretrack from Eric Weeks.  Revision
; goal: add gaussian fitting to find centroids.  Removed bpass ideas, field stuff...
; epretrack  -- revised version of jpretrack (from John C.  Crocker)
; 
; Douglas Martin 2-10-10
; 
; Suggested Call:
;  dpretrack,stk,11,mass=10000,outvar=out
; where stk is the image stack, and the variable out has already been defined as non-zero.
;
; see:   http://www.physics.emory.edu/~weeks/idl/
;
; routine to analyze time-series stacks or single images to
;    determine where particles are located
;
;  ppretrack -- Peter's version (begun 7/8/97)
;  jpretrack -- John's version (begun 7/8/98)
;  epretrack -- Eric's version (begun 2/15/05)
;  dpretrack -- Doug's version (begun 2/10/10)
;
; Options related to feature:
;     dia,sep,min,mass
;
;     img = the image to be examined

;     f = feature(b,dia,sep,min=min,masscut=mass)
;

;
; Options related to file type:
;     /gdf = use read_gdf
;     /tiff = use read_tiff
;     /multi = use readtiffstack (multiple-image tiff files)
;     /nih = use read_nih (NIH Image files)
;
; Additional options:
;     /quiet = supress printing messages
;     prefix = "pt." by default

pro dpretrack,stk, $
    dia=dia,sep=sep,min=min,mass=mass, $
	gdf=gdf,tiff=tiff,nih=nih,multi=multi, $
	quiet=quiet, outvar=outvar 

msg='Defaults:'

if (not keyword_set(dia)) then begin
	dia = 9 & msg=msg+" dia=9"
endif
if (not keyword_set(sep)) then begin
	sep = dia+1;  this is what feature uses as a default
	msg=msg+" sep-unset"
endif
if (not keyword_set(min)) then begin
	min = 0
	msg=msg+" min-unset"
endif
if (not keyword_set(mass)) then begin
	mass = 0
	msg=msg+" mass-unset"
endif

prefix='pt.'
prefixflag = 0; means user didn't set prefix


if (not keyword_set(quiet)) then begin
	slen = strlen(msg)
	if (slen lt 10) then msg=msg+" no default values used, all user-defined"
	print,"starting dpretrack..."
	print,msg
endif

if (size(stk,/type) eq 7) then begin
	filen = findfile(stk)
	if filen(0) eq '' then message,"No file '"+stk+"' found"
	nfiles = n_elements(filen)
	usingfiles = 1
endif else begin
	nfiles = 1
	usingfiles = 0
endelse

rep = 1

for j =0,nfiles-1 do begin

	if (usingfiles eq 1) then begin
		print,'reading image stack: '+filen(j)
		if (keyword_set(gdf)) then stk=read_gdf(filen(j))
		if (keyword_set(tiff)) then stk=read_tiff(filen(j))
		if (keyword_set(multi)) then stk=readtiffstack(filen(j))
		if (keyword_set(nih)) then stk=read_nih(filen(j))
		
	endif else begin
    if not keyword_set(quiet) then print,'using the image array given to me'
	endelse



	ns = n_elements(stk(0,0,*))
	if ns gt 200 then rep = 25

	ss=size(stk(*,*,0))
	sx = ss(1)

	res = fltarr(6)

	   for i = 0,ns-1 do begin
        if (((i+1) mod rep eq 0) and not keyword_set(quiet)) then begin
          print,'processing frame'+$
          strcompress(i+1)+' out of'+strcompress(ns)+'....'
        endif

; -----  Gaussian Fitting Inserted Here ----------
        f = feature(stk(*,*,i),dia,sep,mass=mass,min=min,quiet=quiet)
        if f(0) ne -1 then begin   ; if there are particles, do a
          tmp=gaussfit_feature(stk(*,*,i),f,dia-1)
          ww=where(tmp(4,*) ne 0,nt) ; skipping the bad particles...
          if nt gt 0 then begin
            tmp=tmp(*,ww)
            res = [[res],[tmp(0:4,*),fltarr(1,nt)+i]]
          endif
        endif
	   endfor

  if keyword_set(outvar) then begin
    outvar=res
  endif else begin
  
  	if (usingfiles eq 1) then begin
  		wname = prefix+filen(j)
  	endif else begin
  		if (prefixflag eq 0) then begin
  			wname = "pretrack.gdf"
  			print,"I wasn't given a file name, so writing data"
  			print,"to default file: ",wname
  		endif else begin
  			wname = prefix
  		endelse
  	endelse
  	if (not keyword_set(quiet)) then $
  		print,'writing output file to:' + wname
    write_gdf,res(*,1:*),wname
    
  endelse
	
endfor

end
