analearn <- function(nboot = 10000, naivelevel = 'N', refmutation = NA, datname = NA, header = TRUE, seed = NA, writeoutput = TRUE) {
  if (!is.na(seed)) set.seed(seed)
  if (is.na(datname)) datname <- file.choose()
  datfile <- read.table(datname,header = header,stringsAsFactors = FALSE)
  idstr <- strsplit(datfile[,1],'_')
  datfile$mutation <- as.factor(unlist(lapply(idstr,'[[',1)))
  if (is.na(refmutation) || !(refmutation %in% levels(datfile$mutation))){
    cat('The following mutations are observed:\n')
    for(i in seq_along(levels(datfile$mutation))) {
      cat(i,': ',levels(datfile$mutation)[i],'\n', sep = "")
    }
    cat('Please indicate the reference mutation by giving a number from 1 to ',length(levels(datfile$mutation)),' followed by <Enter>.\n',sep = "")
    refnum <- readline()
    refmutation <- levels(datfile$mutation)[as.numeric(refnum)]}
  datfile$mutation <- relevel(datfile$mutation,refmutation)
  datfile$learncon <- as.factor(unlist(lapply(idstr,'[[',2)))
  datfile$learncon <- relevel(datfile$learncon,naivelevel)
  aggrdat <- aggregate(CI ~ mutation + learncon, data = datfile, FUN = mean)
  LIout <- data.frame(mutation = "", learningcondition = "", CInaive = 0, CItrained = 0, LI = 0, LIdif = 0,LL95CI = 0, UL95CI = 0 ,p = 0, stringsAsFactors = FALSE)
  k = 0
  for (i in levels(aggrdat$learncon)[-1]) {
    k <- k + 1
    LIout[k,"mutation"] <- levels(aggrdat$mutation)[1]
    LIout[k,"learningcondition"] <- i
    LIout[k,"CInaive"] <- aggrdat[aggrdat$mutation == LIout[k,"mutation"] & aggrdat$learncon == naivelevel,"CI"]
    LIout[k,"CItrained"] <- aggrdat[aggrdat$mutation == LIout[k,"mutation"] & aggrdat$learncon == i,"CI"]
    LIout[k,"LI"] <- (LIout[k,"CInaive"] - LIout[k,"CItrained"])/LIout[k,"CInaive"]
    LIout[k,"LIdif"] <- NA
    LIout[k,"LL95CI"] <- NA
    LIout[k,"UL95CI"] <- NA
    LIout[k,"p"]<- NA
    for(j in levels(aggrdat$mutation)[-1]) { 
      k <- k + 1
      LIout[k,"mutation"] <- j
      LIout[k,"learningcondition"] <- i
      LIout[k,"CInaive"] <- aggrdat[aggrdat$mutation == j & aggrdat$learncon == naivelevel,"CI"]
      LIout[k,"CItrained"] <- aggrdat[aggrdat$mutation == j & aggrdat$learncon == i,"CI"]
      LIout[k,"LI"] <- (LIout[k,"CInaive"] - LIout[k,"CItrained"])/LIout[k,"CInaive"]
      LIout[k,"LIdif"] <- LIout[LIout$mutation == levels(aggrdat$mutation)[1] & LIout$learningcondition == i,"LI"] - LIout[k,"LI"]
      LIout[k,"LL95CI"] <- NA
      LIout[k,"UL95CI"] <- NA
      LIout[k,"p"]<- NA
      
    }
  }
  datsplit <- with(datfile, split(datfile, list(mutation,learncon)))
  bootres = matrix(0, nrow = nboot, ncol = (length(levels(aggrdat$mutation))-1)*(length(levels(aggrdat$learncon))-1))
  CIsplit = list()
  for (i in seq_len(nboot)) {
    for (j in names(datsplit)) {
      datstuk <- datsplit[[j]]
      CIsplit[j]<- mean(datstuk[sample(NROW(datstuk),replace = TRUE),"CI"])
    }
    CInames <- matrix(unlist(strsplit(names(CIsplit),'\\.')),ncol = 2, byrow = TRUE)
    aggrtemp <- data.frame(mutation = as.factor(CInames[,1]), learncon = as.factor(CInames[,2]),CI = unlist(CIsplit))
    aggrtemp$mutation <- relevel(aggrtemp$mutation,levels(datfile$mutation)[1])
    aggrtemp$learncon <- relevel(aggrtemp$learncon,naivelevel)
    for (l in levels(aggrtemp$learncon)[-1]) {
      for (m in levels(aggrtemp$mutation)){
        aggrtemp[aggrtemp$mutation==m & aggrtemp$learncon == l,'LI'] <- (aggrtemp[aggrtemp$mutation==m & aggrtemp$learncon == naivelevel,'CI'] - aggrtemp[aggrtemp$mutation==m & aggrtemp$learncon == l,'CI'])/aggrtemp[aggrtemp$mutation==m & aggrtemp$learncon == naivelevel,'CI']
      }
    }
    k <- 0
    for (l in levels(aggrtemp$learncon)[-1]) {
      for (m in levels(aggrtemp$mutation)[-1]){
        k <- k + 1
        bootres[i,k] <- aggrtemp[aggrtemp$mutation==levels(aggrtemp$mutation)[1] & aggrtemp$learncon == l,'LI'] - aggrtemp[aggrtemp$mutation==m & aggrtemp$learncon == l,'LI']
      }
    }
    
  }
  k <- 0
  for (i in levels(aggrtemp$learncon)[-1]) {
    for(j in levels(aggrtemp$mutation)[-1]) {
      k <- k + 1
      LIout[LIout$mutation == j & LIout$learningcondition == i,"LL95CI"] <- quantile(bootres[,k],probs = 0.025)
      LIout[LIout$mutation == j & LIout$learningcondition == i,"UL95CI"] <- quantile(bootres[,k],probs = 0.975)
      p <- mean(bootres[,k]>0)
      if(p>0.5) p <- 1 - p
      if (p < 1) p <- p*2
      LIout[LIout$mutation == j & LIout$learningcondition == i,"p"] <- p
      
    }
  }  
  if (writeoutput) {
    outname <- unlist(strsplit(datname,'\\.'))
    outname[length(outname)-1] <- paste(outname[length(outname)-1],'out',sep = '')
    outname <- paste(outname, sep = '', collapse = '.')
    if (file.exists(outname)) {
      cat('Output file ', outname, ' already exists. Overwrite? <y/n>\n')
      if(!readline() == 'y') outname <- file.choose()
    }
    sink(outname)
    cat('Analyzing file ',datname,'\n')
    cat('Based on ',nboot,' bootstrap replications.\n\n')
    print(LIout)
    sink()
  }
  LIout
}
  

