%% 
% #define LED_OFF 1
% #define LED_ON 2
% #define UPDATE_LEDS 3
% #define TONE_ON 4
% #define TONE_OFF 5
% #define SHOCK_ON 6
% #define SHOCK_OFF 7
% #define UPDATE_BANK 8
% #define UPDATE_ALL_LEDS 9
% #define UART_RX 10
% #define LIGHT_ON 14
% #define LIGHT_OFF 15

%%
function [] = sendTable(comPort, eventTable)

    a = serial(comPort);
    fopen(a);
    
    BYTEWRAPPER = 101;
    BYTEWRAPPER_16 = 102;
    BYTEWRAPPER_32 = 104; 
    
    EXECUTE = 3;
    PAUSE = 4;
    RESET = 5;
    RETURN_TABLE = 6;

    for i = 1:size(eventTable,1)
        for j = 1: size(eventTable,2)

                
            if eventTable(i,j) <= intmax('uint8') %255
                fwrite(a, BYTEWRAPPER)
                fwrite(a, eventTable(i,j), 'uint8')
            elseif eventTable(i,j) <= intmax('uint16') %65535
                fwrite(a, BYTEWRAPPER_16) 
                fwrite(a,eventTable(i,j),'uint16')
            elseif eventTable(i,j) <= intmax('uint32') %4294967295 is 4 bytes %16777216 is 3 bytes
                fwrite(a, BYTEWRAPPER_32) 
                fwrite(a,eventTable(i,j),'uint32')    
            else 
                fwrite(a, BYTEWRAPPER_64)
                fwrite(a,eventTable(i,j),'uint64')               
            end

                
                
        
                
        end
    end
    
   
    fclose(a);
    
end





