%Cut Power Circuit Boards

%%%PARAMETERS TO INPUT
filename = 'PCB_01'; %Output file name
zdepth = -25; %Thickness of the PCB
tracedepth = -10; %Depth of the cut to remove the top layer of copper
offset=[1000 600];%The coordinates of the center of the first PCB
xreps=9; %Number of repetitions along the x-axis
xspace=500; %Spacing between PCBs along the x-axis
yreps=1; %Number of repetitions along the y-axis
yspace=300; %Spacing between PCBs along the y-axis
tracelength=200; %Length of traces for wirebonding
tracewidth=32; %Spacing between leads on power connector
traces=5; %Number of leads on power cuonnector
innercut=[-95,-50;95,-50;95,50;-95,50]; %Outline of the hole for the connector, not accounting for bit width
outercut=[-165,-150;165,-150;165,185;-165,185]; %Outline of the PCB, not accounting for bit width
grounds=[-110,-100;110,-100]; %Location of holes for connecting top and bottom of PCB

%%%CODE WHICH GENERATES .rml FILES

fida = fopen([filename,'a.rml'],'w');
fidb = fopen([filename,'b.rml'],'w');
fprintf(fida,'PA;PA;VS1;!VZ.5;!MC1;!PZ%i,15;',tracedepth);
fprintf(fidb,'PA;PA;VS2;!VZ.5;!MC1;!PZ%i,15;',zdepth);

for h=1:yreps
for i=1:xreps
    offs=offset+[(i-1)*xspace,(h-1)*yspace];
    inc = innercut + ones(size(innercut))*[offs(1),0;0,offs(2)];
    outc = outercut + ones(size(outercut))*[offs(1),0;0,offs(2)];
    gnds = grounds + ones(size(grounds))*[offs(1),0;0,offs(2)];
    for j=0:traces
        x=(j-traces/2)*tracewidth+offs(1);
        fprintf(fida,'PU%i,%i;PD%i,%i;',[x,offs(2)+30,x,offs(2)+tracelength]);
    end
    fprintf(fida,'!PZ%i,15;',zdepth)
    for j=1:length(grounds)
        fprintf(fida,'PU%i,%i;PD%i,%i;',gnds(j,:),gnds(j,:));
    end
    fprintf(fida,'!PZ%i,15;',tracedepth)
        
    fprintf(fidb,'PU%i,%i;',inc(end,:))
    for j=1:length(inc)
        fprintf(fidb,'PD%i,%i;',inc(j,:))
    end
    
    fprintf(fidb,'PU%i,%i;',outc(end,:))
    for j=1:length(outc)
        fprintf(fidb,'PD%i,%i;',outc(j,:))
    end
end
end
%Avoid file buffer problems
for i=1:1500
    fprintf(fida,'!MC0;');
    fprintf(fidb,'!MC0;');
end
fclose(fida);
fclose(fidb);
        
 