%Drill LED sockets and alignment holes

%%%PARAMETERS TO INPUT
%Input the output file name 
filename = 'Base_Plate_01';
%Determines the depth of the LED sockets
trench_depth = -9;
%Determines the depth of the alignment holes
top_depth = -55;
%Determines the width of the LED sockets
LED_width = 18;
%Input the coordinates of the bottom-left corner of the first base plate
offset=[850, 450];
%Input the number of base plates to mill
xreps=1;
%Input the spacing between base plates 
xspace=355;
%Input the coordinates of the centers of the LEDs
LEDs=[80,95;80,125];
%Inpute the coordinates of the alignment holes
align=[0,0;40,260;80,0;80,220;0,220];




%%%CODE WHICH GENERATES .rml FILES

fid1 = fopen([filename,'a.rml'],'w');
fid2 = fopen([filename,'b.rml'],'w');
fprintf(fid1,'PA;PA;VS.3;!VZ.3;!MC1;!PZ%i,15;',trench_depth);
fprintf(fid2,'PA;PA;VS1;!VZ.3;!MC1;!PZ%i,15;',top_depth);
for i=1:xreps
    offs=offset+(i-1)*[xspace,0];
    L = LEDs + ones(size(LEDs))*[offs(1),0;0,offs(2)];
    A = align + ones(size(align))*[offs(1),0;0,offs(2)];
    for j=1:length(L)
        fprintf(fid1,'PU%i,%i;PD%i,%i;PD%i,%i;PD%i,%i;PD%i,%i;',L(j,:)+[-LED_width/2,-LED_width/2],L(j,:)+[-LED_width/2,LED_width/2],L(j,:)+[LED_width/2,LED_width/2],L(j,:)+[LED_width/2,-LED_width/2],L(j,:)+[-LED_width/2,-LED_width/2]);
    end
    for j=1:length(A)
        fprintf(fid2,'PU%i,%i;PD%i,%i;',A(j,:),A(j,:));
    end
end
%Avoid file buffer problems
for i=1:1500
    fprintf(fid1,'!MC0;');
    fprintf(fid2,'!MC0;');
end
fprintf(1,'all done \n');
fclose(fid1);
fclose(fid2);
        
    