%Make Alignment plates

%%%PARAMETERS TO INPUT
filename = 'Alignment_Plate_01'; %Input the output file name
zdepth = -65; %Thickness of the alignment plate
offset=[700 700]; %Position of the bottom-left corner of the first alignment plate
xreps=2; %Number of repetitions along the x-axis
xspace=480; %Spacing between alignment plates along the x-axis
yreps=1; %Number of repetitions along the y-axis
yspace=300; %Spacing between alignment plates along the y-axis
points=[0,0;95,0;125,0;220,0;220,80;0,80]; %Coordinates to lign up with LED centers and alignment holes
outline=[-60,-80;280,-80;280,140;130,140;130,60;90,60;90,140;-60,140]; %Outline of alignment plate

%%%CODE WHICH GENERATES .rml FILES

fid1 = fopen([filename,'a.rml'],'w'); 
fid2 = fopen([filename,'b.rml'],'w');
fprintf(fid1,'PA;PA;VS.5;!VZ.5;!MC1;!PZ%i,15;',zdepth);
fprintf(fid2,'PA;PA;VS2;!VZ.5;!MC1;!PZ%i,15;',zdepth);
for h=1:yreps
for i=1:xreps
    offs=offset+[(i-1)*xspace,(h-1)*yspace];
    pts = points + ones(size(points))*[offs(1),0;0,offs(2)];
    O = outline + ones(size(outline))*[offs(1),0;0,offs(2)];
    for j=1:length(pts)
        fprintf(fid1,'PU%i,%i;PD%i,%i;',pts(j,:),pts(j,:));
    end
    fprintf(fid2,'PU%i,%i;',O(end,:));
    for j=1:length(O)
        fprintf(fid2,'PD%i,%i;',O(j,:));
    end
end
end
%Avoid file buffer problems
for i=1:1500
    fprintf(fid1,'!MC0;');
    fprintf(fid2,'!MC0;');
end
fclose(fid1); 
fclose(fid2);